/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import junit.framework.TestCase;
import org.activemq.io.util.ByteArray;
import org.activemq.io.util.ByteArrayFragmentation;

public class ByteArrayFragmentationTest
extends TestCase {
    static final int DATA_SIZE = 32768;
    byte[] testData;
    String testString = "";

    protected void setUp() throws Exception {
        super.setUp();
        this.testString = "";
        int i = 0;
        while (this.testString.length() < 32768) {
            this.testString = this.testString + "abcdefg";
            ++i;
        }
        this.testData = this.testString.getBytes();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ByteArrayFragmentationTest(String arg0) {
        super(arg0);
    }

    public void testDoFragmentation() {
        ByteArray ba = new ByteArray(this.testData);
        ByteArrayFragmentation test = new ByteArrayFragmentation();
        test.setFragmentationLimit(10922);
        ByteArrayFragmentationTest.assertTrue((boolean)test.doFragmentation(ba));
        ByteArray[] fragments = test.fragment(ba);
        ByteArrayFragmentationTest.assertTrue((fragments.length > 1 ? 1 : 0) != 0);
        ByteArray assembled = test.assemble(fragments);
        ByteArrayFragmentationTest.assertTrue((boolean)this.isSame(ba, assembled));
    }

    protected boolean isSame(ByteArray b1, ByteArray b2) {
        boolean result = b1.getLength() == b2.getLength();
        for (int i = 0; i < b1.getLength(); ++i) {
            result &= b1.get(i) == b2.get(i);
        }
        return result;
    }
}

