/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.util;

import junit.framework.TestCase;
import org.activemq.io.util.ByteArray;
import org.activemq.io.util.ByteArrayCompression;

public class ByteArrayCompressionTest
extends TestCase {
    static final int DATA_SIZE = 32768;
    byte[] testData;

    protected void setUp() throws Exception {
        super.setUp();
        this.testData = new byte[32768];
        for (int i = 0; i < this.testData.length; ++i) {
            this.testData[i] = 107;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCompression() throws Exception {
        ByteArray ba = new ByteArray(this.testData);
        ByteArrayCompression test = new ByteArrayCompression();
        test.setCompressionLimit(16384);
        ByteArrayCompressionTest.assertFalse((boolean)ByteArrayCompression.isCompressed((ByteArray)ba));
        ByteArray deflated = test.deflate(ba);
        ByteArrayCompressionTest.assertFalse((deflated == ba ? 1 : 0) != 0);
        ByteArrayCompressionTest.assertTrue((boolean)ByteArrayCompression.isCompressed((ByteArray)deflated));
        ByteArrayCompressionTest.assertTrue((deflated.getLength() < ba.getLength() ? 1 : 0) != 0);
        ByteArray inflated = test.inflate(ba);
        ByteArrayCompressionTest.assertFalse((boolean)ByteArrayCompression.isCompressed((ByteArray)inflated));
        ByteArrayCompressionTest.assertTrue((boolean)this.isSame(ba, inflated));
    }

    protected boolean isSame(ByteArray b1, ByteArray b2) {
        boolean result = b1.getLength() == b2.getLength();
        for (int i = 0; i < b1.getLength(); ++i) {
            result &= b1.get(i) == b2.get(i);
        }
        return result;
    }
}

