/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import junit.textui.TestRunner;
import org.activemq.io.impl.XATransactionInfoReader;
import org.activemq.io.impl.XATransactionInfoWriter;
import org.activemq.message.ActiveMQXid;
import org.activemq.message.Packet;
import org.activemq.message.PacketTestSupport;
import org.activemq.message.XATransactionInfo;

public class XATransactionInfoReaderTest
extends PacketTestSupport {
    protected static final int TYPE = 101;
    protected static final ActiveMQXid XID = new ActiveMQXid(123, new byte[]{1, 2, 3, 4}, new byte[]{5, 6, 7, 8, 9, 10});

    public static void main(String[] args) {
        TestRunner.run((Class)XATransactionInfoReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetPacketType() {
        XATransactionInfoReader reader = new XATransactionInfoReader();
        XATransactionInfoReaderTest.assertTrue((reader.getPacketType() == 20 ? 1 : 0) != 0);
    }

    public void testReadXidPacket() throws Exception {
        XATransactionInfo info = (XATransactionInfo)this.createXidPacket();
        XATransactionInfoWriter writer = new XATransactionInfoWriter();
        XATransactionInfoReader reader = new XATransactionInfoReader();
        byte[] data = writer.writePacketToByteArray((Packet)info);
        XATransactionInfo testInfo = (XATransactionInfo)reader.readPacketFromByteArray(data);
        this.assertPacket((Packet)testInfo, (Packet)info);
    }

    public void testReadNoXidPacket() throws Exception {
        XATransactionInfo info = (XATransactionInfo)this.createNoXidPacket();
        XATransactionInfoWriter writer = new XATransactionInfoWriter();
        XATransactionInfoReader reader = new XATransactionInfoReader();
        byte[] data = writer.writePacketToByteArray((Packet)info);
        XATransactionInfo testInfo = (XATransactionInfo)reader.readPacketFromByteArray(data);
        this.assertPacket((Packet)testInfo, (Packet)info);
    }

    public void testTime() {
        XATransactionInfo info = (XATransactionInfo)this.createXidPacket();
        XATransactionInfoWriter writer = new XATransactionInfoWriter();
        XATransactionInfoReader reader = new XATransactionInfoReader();
        XATransactionInfo testInfo = null;
        try {
            int count = 100000;
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)info);
                testInfo = (XATransactionInfo)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            XATransactionInfoReaderTest.fail();
        }
    }

    protected void assertPacket(Packet packet, Packet expected) {
        XATransactionInfo testInfo = (XATransactionInfo)packet;
        XATransactionInfo xaExpected = (XATransactionInfo)expected;
        XATransactionInfoReaderTest.assertEquals((int)xaExpected.getType(), (int)testInfo.getType());
        XATransactionInfoReaderTest.assertEquals((Object)xaExpected.getXid(), (Object)testInfo.getXid());
    }

    protected void assertValidPacket(Packet packet) {
        XATransactionInfo testInfo = (XATransactionInfo)packet;
        XATransactionInfoReaderTest.assertEquals((int)testInfo.getType(), (int)101);
        XATransactionInfoReaderTest.assertEquals((Object)testInfo.getXid(), (Object)XID);
    }

    protected Packet createPacket() {
        return this.createXidPacket();
    }

    protected Packet createXidPacket() {
        XATransactionInfo info = new XATransactionInfo();
        info.setType(101);
        info.setXid(XID);
        return info;
    }

    protected Packet createNoXidPacket() {
        XATransactionInfo info = new XATransactionInfo();
        info.setType(113);
        return info;
    }
}

