/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import junit.textui.TestRunner;
import org.activemq.io.impl.TransactionInfoReader;
import org.activemq.io.impl.TransactionInfoWriter;
import org.activemq.message.Packet;
import org.activemq.message.PacketTestSupport;
import org.activemq.message.TransactionInfo;

public class TransactionInfoReaderTest
extends PacketTestSupport {
    private String TransactionId;
    private int type;

    public static void main(String[] args) {
        TestRunner.run((Class)TransactionInfoReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.TransactionId = "testTransactionId";
        this.type = 113;
    }

    public void testGetPacketType() {
        TransactionInfoReader reader = new TransactionInfoReader();
        TransactionInfoReaderTest.assertTrue((reader.getPacketType() == 19 ? 1 : 0) != 0);
    }

    public void testReadPacket() {
        TransactionInfo info = (TransactionInfo)this.createPacket();
        TransactionInfoWriter writer = new TransactionInfoWriter();
        TransactionInfoReader reader = new TransactionInfoReader();
        try {
            byte[] data = writer.writePacketToByteArray((Packet)info);
            TransactionInfo testInfo = (TransactionInfo)reader.readPacketFromByteArray(data);
            this.assertPacket((Packet)testInfo, (Packet)info);
        }
        catch (Throwable e) {
            e.printStackTrace();
            TransactionInfoReaderTest.assertTrue((boolean)false);
        }
    }

    public void testTime() {
        TransactionInfo info = (TransactionInfo)this.createPacket();
        TransactionInfoWriter writer = new TransactionInfoWriter();
        TransactionInfoReader reader = new TransactionInfoReader();
        TransactionInfo testInfo = null;
        try {
            int count = 100000;
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)info);
                testInfo = (TransactionInfo)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            TransactionInfoReaderTest.assertTrue((boolean)false);
        }
    }

    protected void assertValidPacket(Packet packet) {
        TransactionInfo testInfo = (TransactionInfo)packet;
        TransactionInfoReaderTest.assertTrue((boolean)testInfo.getTransactionId().equals(this.TransactionId));
        TransactionInfoReaderTest.assertTrue((testInfo.getType() == this.type ? 1 : 0) != 0);
    }

    protected Packet createPacket() {
        TransactionInfo info = new TransactionInfo();
        info.setTransactionId(this.TransactionId);
        info.setType(this.type);
        return info;
    }
}

