/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import junit.textui.TestRunner;
import org.activemq.io.impl.ReceiptReader;
import org.activemq.io.impl.ReceiptWriter;
import org.activemq.message.Packet;
import org.activemq.message.PacketTestSupport;
import org.activemq.message.Receipt;

public class ReceiptReaderTest
extends PacketTestSupport {
    private short id;
    private short correlationId;

    public static void main(String[] args) {
        TestRunner.run((Class)ReceiptReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.id = (short)5445;
        this.correlationId = (short)6677;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetPacketType() {
        ReceiptReader reader = new ReceiptReader();
        ReceiptReaderTest.assertTrue((reader.getPacketType() == 16 ? 1 : 0) != 0);
    }

    public void testReadPacket() {
        Receipt info = (Receipt)this.createPacket();
        ReceiptWriter writer = new ReceiptWriter();
        ReceiptReader reader = new ReceiptReader();
        try {
            byte[] data = writer.writePacketToByteArray((Packet)info);
            Receipt receipt = (Receipt)reader.readPacketFromByteArray(data);
            this.assertPacket((Packet)receipt, (Packet)info);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ReceiptReaderTest.assertTrue((boolean)false);
        }
    }

    public void testTime() {
        Receipt info = (Receipt)this.createPacket();
        ReceiptWriter writer = new ReceiptWriter();
        ReceiptReader reader = new ReceiptReader();
        try {
            int count = 100000;
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)info);
                Receipt test = (Receipt)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ReceiptReaderTest.assertTrue((boolean)false);
        }
    }

    protected void assertValidPacket(Packet packet) {
        Receipt receipt = (Receipt)packet;
        ReceiptReaderTest.assertTrue((receipt.getId() == this.id ? 1 : 0) != 0);
        ReceiptReaderTest.assertTrue((receipt.getCorrelationId() == this.correlationId ? 1 : 0) != 0);
    }

    protected Packet createPacket() {
        Receipt info = new Receipt();
        info.setId(this.id);
        info.setCorrelationId(this.correlationId);
        return info;
    }
}

