/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.io.impl.ProducerInfoReader;
import org.activemq.io.impl.ProducerInfoWriter;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.Packet;
import org.activemq.message.ProducerInfo;

public class ProducerInfoReaderTest
extends TestCase {
    private short id;
    private ActiveMQDestination destination;
    private String clientId;
    private long startTime;
    private boolean started;

    public static void main(String[] args) {
        TestRunner.run((Class)ProducerInfoReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.id = (short)3445;
        this.clientId = "testclientId";
        this.destination = new ActiveMQTopic("testtopic");
        this.startTime = System.currentTimeMillis();
        this.started = true;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ProducerInfoReaderTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        ProducerInfoReader reader = new ProducerInfoReader();
        ProducerInfoReaderTest.assertTrue((reader.getPacketType() == 18 ? 1 : 0) != 0);
    }

    public void testReadPacket() {
        ProducerInfo info = new ProducerInfo();
        info.setId(this.id);
        info.setClientId(this.clientId);
        info.setDestination(this.destination);
        info.setStartTime(this.startTime);
        info.setStarted(this.started);
        ProducerInfoWriter writer = new ProducerInfoWriter();
        ProducerInfoReader reader = new ProducerInfoReader();
        try {
            byte[] data = writer.writePacketToByteArray((Packet)info);
            ProducerInfo testInfo = (ProducerInfo)reader.readPacketFromByteArray(data);
            ProducerInfoReaderTest.assertTrue((testInfo.getId() == this.id ? 1 : 0) != 0);
            ProducerInfoReaderTest.assertTrue((boolean)testInfo.getClientId().equals(this.clientId));
            ProducerInfoReaderTest.assertTrue((boolean)testInfo.getDestination().equals((Object)this.destination));
            ProducerInfoReaderTest.assertTrue((testInfo.getStartTime() == this.startTime ? 1 : 0) != 0);
            ProducerInfoReaderTest.assertTrue((testInfo.isStarted() == this.started ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ProducerInfoReaderTest.assertTrue((boolean)false);
        }
    }

    public void testTime() {
        ProducerInfo info = new ProducerInfo();
        info.setId(this.id);
        info.setClientId(this.clientId);
        info.setDestination(this.destination);
        info.setStartTime(this.startTime);
        info.setStarted(this.started);
        ProducerInfoWriter writer = new ProducerInfoWriter();
        ProducerInfoReader reader = new ProducerInfoReader();
        ProducerInfo testInfo = null;
        try {
            int count = 100000;
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)info);
                testInfo = (ProducerInfo)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ProducerInfoReaderTest.assertTrue((boolean)false);
        }
    }
}

