/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.io.impl.MessageAckReader;
import org.activemq.io.impl.MessageAckWriter;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.MessageAck;
import org.activemq.message.Packet;

public class MessageAckReaderTest
extends TestCase {
    private short id;
    private String consumerId;
    private String messageId;
    private Object transactedId;
    private boolean messageRead;
    private boolean persistent;
    private ActiveMQDestination destination;
    private boolean xaTransacted;
    private boolean expired;

    public static void main(String[] args) {
        TestRunner.run((Class)MessageAckReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.id = (short)3445;
        this.consumerId = "testid";
        this.messageId = "ID:ewrre-erer-err";
        this.transactedId = "45454";
        this.messageRead = true;
        this.persistent = true;
        this.xaTransacted = false;
        this.expired = true;
        this.destination = new ActiveMQTopic("FOO.BAR");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public MessageAckReaderTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        MessageAckReader reader = new MessageAckReader();
        MessageAckReaderTest.assertTrue((reader.getPacketType() == 15 ? 1 : 0) != 0);
    }

    public void testReadPacket() {
        MessageAck ack = new MessageAck();
        ack.setId(this.id);
        ack.setConsumerId(this.consumerId);
        ack.setTransactionId(this.transactedId);
        ack.setMessageID(this.messageId);
        ack.setMessageRead(this.messageRead);
        ack.setPersistent(this.persistent);
        ack.setDestination(this.destination);
        ack.setExpired(this.expired);
        MessageAckWriter writer = new MessageAckWriter();
        MessageAckReader reader = new MessageAckReader();
        try {
            byte[] data = writer.writePacketToByteArray((Packet)ack);
            MessageAck mack = (MessageAck)reader.readPacketFromByteArray(data);
            MessageAckReaderTest.assertTrue((boolean)mack.getConsumerId().equals(this.consumerId));
            MessageAckReaderTest.assertTrue((boolean)mack.getTransactionId().equals(this.transactedId));
            MessageAckReaderTest.assertTrue((mack.isMessageRead() == this.messageRead ? 1 : 0) != 0);
            MessageAckReaderTest.assertTrue((mack.isPersistent() == this.persistent ? 1 : 0) != 0);
            MessageAckReaderTest.assertTrue((mack.isExpired() == this.expired ? 1 : 0) != 0);
            MessageAckReaderTest.assertTrue((mack.isXaTransacted() == this.xaTransacted ? 1 : 0) != 0);
            MessageAckReaderTest.assertTrue((boolean)mack.getDestination().equals((Object)this.destination));
        }
        catch (Throwable e) {
            e.printStackTrace();
            MessageAckReaderTest.fail((String)e.getMessage());
        }
    }

    public void testTime() {
        MessageAck ack = new MessageAck();
        ack.setId(this.id);
        ack.setConsumerId(this.consumerId);
        ack.setTransactionId(this.transactedId);
        ack.setMessageID(this.messageId);
        ack.setMessageRead(this.messageRead);
        ack.setPersistent(this.persistent);
        ack.setDestination(this.destination);
        MessageAckWriter writer = new MessageAckWriter();
        MessageAckReader reader = new MessageAckReader();
        try {
            int count = 100000;
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)ack);
                MessageAck mack = (MessageAck)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            MessageAckReaderTest.assertTrue((boolean)false);
        }
    }
}

