/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.io.impl.ConsumerInfoReader;
import org.activemq.io.impl.ConsumerInfoWriter;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.Packet;

public class ConsumerInfoReaderTest
extends TestCase {
    private String consumerId;
    private ActiveMQDestination destination;
    private String clientId;
    private String subscriberName;
    private String selector;
    private long startTime;
    private boolean started;
    private int consumerNo;
    private int prefetchNumber;

    public static void main(String[] args) {
        TestRunner.run((Class)ConsumerInfoReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.consumerId = "testConsumerId";
        this.clientId = "testclientId";
        this.subscriberName = "testsubscriberName";
        this.selector = "testselector";
        this.destination = new ActiveMQTopic("testtopic");
        this.startTime = System.currentTimeMillis();
        this.started = true;
        this.consumerNo = 3;
        this.prefetchNumber = 13;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ConsumerInfoReaderTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        ConsumerInfoReader reader = new ConsumerInfoReader();
        ConsumerInfoReaderTest.assertTrue((reader.getPacketType() == 17 ? 1 : 0) != 0);
    }

    public void testReadPacket() {
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.consumerId);
        info.setConsumerNo(this.consumerNo);
        info.setPrefetchNumber(this.prefetchNumber);
        info.setClientId(this.clientId);
        info.setConsumerName(this.subscriberName);
        info.setSelector(this.selector);
        info.setDestination(this.destination);
        info.setStartTime(this.startTime);
        info.setStarted(this.started);
        ConsumerInfoWriter writer = new ConsumerInfoWriter();
        ConsumerInfoReader reader = new ConsumerInfoReader();
        try {
            byte[] data = writer.writePacketToByteArray((Packet)info);
            ConsumerInfo testInfo = (ConsumerInfo)reader.readPacketFromByteArray(data);
            ConsumerInfoReaderTest.assertTrue((boolean)testInfo.getConsumerId().equals(this.consumerId));
            ConsumerInfoReaderTest.assertTrue((testInfo.getConsumerNo() == this.consumerNo ? 1 : 0) != 0);
            ConsumerInfoReaderTest.assertTrue((testInfo.getPrefetchNumber() == this.prefetchNumber ? 1 : 0) != 0);
            ConsumerInfoReaderTest.assertTrue((boolean)testInfo.getClientId().equals(this.clientId));
            ConsumerInfoReaderTest.assertTrue((boolean)testInfo.getConsumerName().equals(this.subscriberName));
            ConsumerInfoReaderTest.assertTrue((boolean)testInfo.getSelector().equals(this.selector));
            ConsumerInfoReaderTest.assertTrue((boolean)testInfo.getDestination().equals((Object)this.destination));
            ConsumerInfoReaderTest.assertTrue((testInfo.getStartTime() == this.startTime ? 1 : 0) != 0);
            ConsumerInfoReaderTest.assertTrue((testInfo.isStarted() == this.started ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ConsumerInfoReaderTest.assertTrue((boolean)false);
        }
    }

    public void testTime() {
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.consumerId);
        info.setConsumerNo(this.consumerNo);
        info.setPrefetchNumber(this.prefetchNumber);
        info.setClientId(this.clientId);
        info.setConsumerName(this.subscriberName);
        info.setSelector(this.selector);
        info.setDestination(this.destination);
        info.setStartTime(this.startTime);
        info.setStarted(this.started);
        ConsumerInfoWriter writer = new ConsumerInfoWriter();
        ConsumerInfoReader reader = new ConsumerInfoReader();
        ConsumerInfo testInfo = null;
        try {
            int count = 100000;
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)info);
                testInfo = (ConsumerInfo)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ConsumerInfoReaderTest.assertTrue((boolean)false);
        }
    }
}

