/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.IOException;
import javax.jms.JMSException;
import junit.textui.TestRunner;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.ActiveMQMessageReaderTest;
import org.activemq.io.impl.ActiveMQTextMessageReader;
import org.activemq.io.impl.ActiveMQTextMessageWriter;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.Packet;

public class ActiveMQTextMessageReaderTest
extends ActiveMQMessageReaderTest {
    private String testStr;

    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQTextMessageReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        StringBuffer buf = new StringBuffer();
        char start = 'a';
        int total = 102400;
        int count = 0;
        while (count < total) {
            char c = start;
            for (int i = 0; i < 26; ++i) {
                buf.append(c);
                c = (char)(c + '\u0001');
                ++count;
            }
        }
        this.testStr = buf.toString();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQTextMessageReaderTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        ActiveMQTextMessage msg = new ActiveMQTextMessage();
        ActiveMQTextMessageReaderTest.assertTrue((msg.getPacketType() == 7 ? 1 : 0) != 0);
    }

    public void testReadPacket() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQTextMessageReader reader = new ActiveMQTextMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQTextMessageWriter writer = new ActiveMQTextMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQTextMessage msg1 = new ActiveMQTextMessage();
        try {
            msg1.setText(this.testStr);
            super.initializeMessage((ActiveMQMessage)msg1);
            byte[] data = writer.writePacketToByteArray((Packet)msg1);
            ActiveMQTextMessage msg2 = (ActiveMQTextMessage)reader.readPacketFromByteArray(data);
            super.testEquals((ActiveMQMessage)msg1, (ActiveMQMessage)msg2);
            ActiveMQTextMessageReaderTest.assertTrue((boolean)msg1.getText().equals(msg2.getText()));
        }
        catch (IOException e) {
            e.printStackTrace();
            ActiveMQTextMessageReaderTest.assertTrue((boolean)false);
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            ActiveMQTextMessageReaderTest.assertTrue((boolean)false);
        }
    }

    public void testTime() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQTextMessageReader reader = new ActiveMQTextMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQTextMessageWriter writer = new ActiveMQTextMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQTextMessage msg1 = new ActiveMQTextMessage();
        ActiveMQTextMessage msg2 = null;
        try {
            int count = 10000;
            long startTime = System.currentTimeMillis();
            msg1.setText("this is a test str");
            super.initializeMessage((ActiveMQMessage)msg1);
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)msg1);
                msg2 = (ActiveMQTextMessage)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ActiveMQTextMessageReaderTest.assertTrue((boolean)false);
        }
    }
}

