/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.IOException;
import java.util.Enumeration;
import javax.jms.JMSException;
import junit.textui.TestRunner;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.ActiveMQMessageReaderTest;
import org.activemq.io.impl.ActiveMQStreamMessageReader;
import org.activemq.io.impl.ActiveMQStreamMessageWriter;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQStreamMessage;
import org.activemq.message.Packet;

public class ActiveMQStreamMessageReaderTest
extends ActiveMQMessageReaderTest {
    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQStreamMessageReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQStreamMessageReaderTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        ActiveMQStreamMessageReaderTest.assertTrue((msg.getPacketType() == 10 ? 1 : 0) != 0);
    }

    public void testReadPacket() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQStreamMessageReader reader = new ActiveMQStreamMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQStreamMessageWriter writer = new ActiveMQStreamMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQStreamMessage msg1 = new ActiveMQStreamMessage();
        try {
            msg1.setBooleanProperty("booleanprop", true);
            msg1.setLongProperty("longproperty", 67L);
            msg1.setFloatProperty("floatproperty", 4.6f);
            super.initializeMessage((ActiveMQMessage)msg1);
            byte[] data = writer.writePacketToByteArray((Packet)msg1);
            ActiveMQStreamMessage msg2 = (ActiveMQStreamMessage)reader.readPacketFromByteArray(data);
            super.testEquals((ActiveMQMessage)msg1, (ActiveMQMessage)msg2);
            Enumeration e = msg1.getPropertyNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement().toString();
                ActiveMQStreamMessageReaderTest.assertTrue((boolean)msg1.getObjectProperty(name).equals(msg2.getObjectProperty(name)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ActiveMQStreamMessageReaderTest.assertTrue((boolean)false);
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            ActiveMQStreamMessageReaderTest.assertTrue((boolean)false);
        }
    }

    public void testTime() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQStreamMessageReader reader = new ActiveMQStreamMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQStreamMessageWriter writer = new ActiveMQStreamMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQStreamMessage msg1 = new ActiveMQStreamMessage();
        ActiveMQStreamMessage msg2 = null;
        try {
            int count = 10000;
            long startTime = System.currentTimeMillis();
            msg1.setBooleanProperty("booleanprop", true);
            msg1.setLongProperty("longproperty", 67L);
            msg1.setFloatProperty("floatproperty", 4.6f);
            super.initializeMessage((ActiveMQMessage)msg1);
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)msg1);
                msg2 = (ActiveMQStreamMessage)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ActiveMQStreamMessageReaderTest.assertTrue((boolean)false);
        }
    }
}

