/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.JMSException;
import junit.textui.TestRunner;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.ActiveMQMessageReaderTest;
import org.activemq.io.impl.ActiveMQObjectMessageReader;
import org.activemq.io.impl.ActiveMQObjectMessageWriter;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQObjectMessage;
import org.activemq.message.Packet;

public class ActiveMQObjectMessageReaderTest
extends ActiveMQMessageReaderTest {
    private Hashtable table;

    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQObjectMessageReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.table = new Hashtable();
        for (int i = 0; i < 10; ++i) {
            String str = "test" + i;
            this.table.put(str, str);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQObjectMessageReaderTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
        ActiveMQObjectMessageReaderTest.assertTrue((msg.getPacketType() == 8 ? 1 : 0) != 0);
    }

    public void testReadPacket() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQObjectMessageReader reader = new ActiveMQObjectMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQObjectMessageWriter writer = new ActiveMQObjectMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQObjectMessage msg1 = new ActiveMQObjectMessage();
        try {
            msg1.setObject((Serializable)this.table);
            super.initializeMessage((ActiveMQMessage)msg1);
            byte[] data = writer.writePacketToByteArray((Packet)msg1);
            ActiveMQObjectMessage msg2 = (ActiveMQObjectMessage)reader.readPacketFromByteArray(data);
            super.testEquals((ActiveMQMessage)msg1, (ActiveMQMessage)msg2);
            ActiveMQObjectMessageReaderTest.assertTrue((boolean)msg1.getObject().equals(msg2.getObject()));
        }
        catch (IOException e) {
            e.printStackTrace();
            ActiveMQObjectMessageReaderTest.assertTrue((boolean)false);
        }
        catch (JMSException ex) {
            ex.printStackTrace();
            ActiveMQObjectMessageReaderTest.assertTrue((boolean)false);
        }
    }

    public void testTime() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQObjectMessageReader reader = new ActiveMQObjectMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQObjectMessageWriter writer = new ActiveMQObjectMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQObjectMessage msg1 = new ActiveMQObjectMessage();
        ActiveMQObjectMessage msg2 = null;
        try {
            int count = 10000;
            long startTime = System.currentTimeMillis();
            msg1.setObject((Serializable)this.table);
            super.initializeMessage((ActiveMQMessage)msg1);
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)msg1);
                msg2 = (ActiveMQObjectMessage)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ActiveMQObjectMessageReaderTest.assertTrue((boolean)false);
        }
    }
}

