/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.ActiveMQMessageReader;
import org.activemq.io.impl.ActiveMQMessageWriter;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTemporaryTopic;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.Packet;

public class ActiveMQMessageReaderTest
extends TestCase {
    private String jmsMessageID;
    private String jmsClientID;
    private String jmsCorrelationID;
    private ActiveMQDestination jmsDestination;
    private ActiveMQDestination jmsReplyTo;
    private int jmsDeliveryMode;
    private boolean jmsRedelivered;
    private String jmsType;
    private long jmsExpiration;
    private int jmsPriority;
    private long jmsTimestamp;
    private HashMap properties;
    private String entryBrokerName;
    private String entryClusterName;
    private int[] consumerIDs;
    private String transactionId;

    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQMessageReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jmsMessageID = "testid";
        this.jmsClientID = "testclientid";
        this.jmsCorrelationID = "testcorrelationid";
        this.jmsDestination = new ActiveMQTopic("test.topic");
        this.jmsReplyTo = new ActiveMQTemporaryTopic("test.replyto.topic");
        this.jmsDeliveryMode = 1;
        this.jmsRedelivered = true;
        this.jmsType = "test type";
        this.jmsExpiration = 100000L;
        this.jmsPriority = 5;
        this.jmsTimestamp = System.currentTimeMillis();
        this.entryBrokerName = "test broker";
        this.entryClusterName = "test cluster";
        this.consumerIDs = new int[3];
        this.transactionId = "testtransactonId";
        for (int i = 0; i < this.consumerIDs.length; ++i) {
            this.consumerIDs[i] = i;
        }
        this.properties = new HashMap();
        this.properties.put("doubletype", new Double(4.6));
        this.properties.put("floatType", new Float(3.3f));
        this.properties.put("inttype", new Integer(2));
        this.properties.put("longtype", new Long(45L));
    }

    protected void initializeMessage(ActiveMQMessage msg) {
        msg.setJMSMessageID(this.jmsMessageID);
        msg.setJMSClientID(this.jmsClientID);
        msg.setJMSCorrelationID(this.jmsCorrelationID);
        msg.setJMSDestination((Destination)this.jmsDestination);
        msg.setJMSReplyTo((Destination)this.jmsReplyTo);
        msg.setJMSDeliveryMode(this.jmsDeliveryMode);
        msg.setJMSRedelivered(this.jmsRedelivered);
        msg.setJMSType(this.jmsType);
        msg.setJMSExpiration(this.jmsExpiration);
        msg.setJMSPriority(this.jmsPriority);
        msg.setJMSTimestamp(this.jmsTimestamp);
        msg.setProperties((Map)this.properties);
        msg.setReadOnly(true);
        msg.setEntryBrokerName(this.entryBrokerName);
        msg.setEntryClusterName(this.entryClusterName);
        msg.setConsumerNos(this.consumerIDs);
        msg.setTransactionId((Object)this.transactionId);
        msg.setExternalMessageId(true);
    }

    protected void testEquals(ActiveMQMessage msg1, ActiveMQMessage msg2) {
        ActiveMQMessageReaderTest.assertTrue((boolean)msg1.getJMSMessageID().equals(msg2.getJMSMessageID()));
        ActiveMQMessageReaderTest.assertTrue((boolean)msg1.getJMSClientID().equals(msg2.getJMSClientID()));
        ActiveMQMessageReaderTest.assertTrue((boolean)msg1.getJMSCorrelationID().equals(msg2.getJMSCorrelationID()));
        ActiveMQMessageReaderTest.assertTrue((boolean)msg1.getJMSDestination().equals(msg2.getJMSDestination()));
        ActiveMQMessageReaderTest.assertTrue((boolean)msg1.getJMSReplyTo().equals(msg2.getJMSReplyTo()));
        ActiveMQMessageReaderTest.assertTrue((msg1.getJMSDeliveryMode() == msg2.getJMSDeliveryMode() ? 1 : 0) != 0);
        ActiveMQMessageReaderTest.assertTrue((msg1.getJMSRedelivered() == msg2.getJMSRedelivered() ? 1 : 0) != 0);
        ActiveMQMessageReaderTest.assertTrue((boolean)msg1.getJMSType().equals(msg2.getJMSType()));
        ActiveMQMessageReaderTest.assertTrue((msg1.getJMSExpiration() == msg2.getJMSExpiration() ? 1 : 0) != 0);
        ActiveMQMessageReaderTest.assertTrue((msg1.getJMSPriority() == msg2.getJMSPriority() ? 1 : 0) != 0);
        ActiveMQMessageReaderTest.assertTrue((msg1.getJMSTimestamp() == msg2.getJMSTimestamp() ? 1 : 0) != 0);
        ActiveMQMessageReaderTest.assertTrue((boolean)msg1.getEntryBrokerName().equals(msg2.getEntryBrokerName()));
        ActiveMQMessageReaderTest.assertTrue((boolean)msg1.getEntryClusterName().equals(msg2.getEntryClusterName()));
        ActiveMQMessageReaderTest.assertTrue((boolean)msg1.getTransactionId().equals(msg2.getTransactionId()));
        int[] cid1 = msg1.getConsumerNos();
        int[] cid2 = msg2.getConsumerNos();
        ActiveMQMessageReaderTest.assertTrue((cid1.length == cid2.length ? 1 : 0) != 0);
        for (int i = 0; i < cid1.length; ++i) {
            ActiveMQMessageReaderTest.assertTrue((cid1[i] == cid2[i] ? 1 : 0) != 0);
        }
        ActiveMQMessageReaderTest.assertTrue((boolean)((Object)msg1.getProperties()).equals(msg2.getProperties()));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQMessageReaderTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQMessageReader reader = new ActiveMQMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQMessageReaderTest.assertTrue((reader.getPacketType() == 6 ? 1 : 0) != 0);
    }

    public void testReadPacket() throws Exception {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQMessageReader reader = new ActiveMQMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQMessageWriter writer = new ActiveMQMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQMessage msg1 = new ActiveMQMessage();
        this.initializeMessage(msg1);
        byte[] data = writer.writePacketToByteArray((Packet)msg1);
        ActiveMQMessage msg2 = (ActiveMQMessage)reader.readPacketFromByteArray(data);
        this.testEquals(msg1, msg2);
        ActiveMQMessage msg3 = msg2.shallowCopy();
        this.testEquals(msg1, msg3);
        data = writer.writePacketToByteArray((Packet)msg3);
        ActiveMQMessage msg4 = (ActiveMQMessage)reader.readPacketFromByteArray(data);
        this.testEquals(msg1, msg4);
    }

    public void testCaching() throws Exception {
        DefaultWireFormat wf = new DefaultWireFormat();
        wf.setCachingEnabled(true);
        ActiveMQMessage msg1 = new ActiveMQMessage();
        this.initializeMessage(msg1);
        for (int i = 0; i < Short.MAX_VALUE; ++i) {
            msg1.setProducerKey("Prod:" + i);
            msg1.setTransactionId((Object)("Transaction:" + i));
            msg1.setJMSDestination((Destination)new ActiveMQQueue("queue." + i));
            msg1.setJMSReplyTo((Destination)new ActiveMQQueue("replyto." + i));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            wf.setTransportDataOut(dos);
            wf.writePacket((Packet)msg1, (DataOutput)dos);
            dos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DataInputStream dis = new DataInputStream(bais);
            wf.setTransportDataIn(dis);
            ActiveMQMessage msg2 = (ActiveMQMessage)wf.readPacket((DataInput)dis);
            while (msg2 == null) {
                msg2 = (ActiveMQMessage)wf.readPacket((DataInput)dis);
            }
            this.testEquals(msg1, msg2);
        }
    }
}

