/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import junit.textui.TestRunner;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.ActiveMQMapMessageReader;
import org.activemq.io.impl.ActiveMQMapMessageWriter;
import org.activemq.io.impl.ActiveMQMessageReaderTest;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.message.ActiveMQMapMessage;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.Packet;

public class ActiveMQMapMessageReaderTest
extends ActiveMQMessageReaderTest {
    private HashMap table;

    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQMapMessageReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.table = new HashMap();
        for (int i = 0; i < 10; ++i) {
            String str = "test" + i;
            this.table.put(str, str);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQMapMessageReaderTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        ActiveMQMapMessage msg = new ActiveMQMapMessage();
        ActiveMQMapMessageReaderTest.assertTrue((msg.getPacketType() == 11 ? 1 : 0) != 0);
    }

    public void testReadPacket() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQMapMessageReader reader = new ActiveMQMapMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQMapMessageWriter writer = new ActiveMQMapMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQMapMessage msg1 = new ActiveMQMapMessage();
        try {
            msg1.setTable((Map)this.table);
            super.initializeMessage((ActiveMQMessage)msg1);
            byte[] data = writer.writePacketToByteArray((Packet)msg1);
            ActiveMQMapMessage msg2 = (ActiveMQMapMessage)reader.readPacketFromByteArray(data);
            super.testEquals((ActiveMQMessage)msg1, (ActiveMQMessage)msg2);
            ActiveMQMapMessageReaderTest.assertTrue((boolean)((Object)msg1.getTable()).equals(msg2.getTable()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQMapMessageReaderTest.assertTrue((boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
            ActiveMQMapMessageReaderTest.assertTrue((boolean)false);
        }
    }

    public void testTime() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQMapMessageReader reader = new ActiveMQMapMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQMapMessageWriter writer = new ActiveMQMapMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQMapMessage msg1 = new ActiveMQMapMessage();
        ActiveMQMapMessage msg2 = null;
        try {
            int count = 10000;
            long startTime = System.currentTimeMillis();
            msg1.setTable((Map)this.table);
            super.initializeMessage((ActiveMQMessage)msg1);
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)msg1);
                msg2 = (ActiveMQMapMessage)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ActiveMQMapMessageReaderTest.assertTrue((boolean)false);
        }
    }
}

