/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.IOException;
import junit.textui.TestRunner;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.ActiveMQBytesMessageReader;
import org.activemq.io.impl.ActiveMQBytesMessageWriter;
import org.activemq.io.impl.ActiveMQMessageReaderTest;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.io.util.ByteArray;
import org.activemq.message.ActiveMQBytesMessage;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.Packet;

public class ActiveMQBytesMessageReaderTest
extends ActiveMQMessageReaderTest {
    private byte[] testdata;

    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQBytesMessageReaderTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testdata = new byte[2048];
        for (int i = 0; i < this.testdata.length; ++i) {
            this.testdata[i] = (byte)i;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQBytesMessageReaderTest(String arg0) {
        super(arg0);
    }

    public void testGetPacketType() {
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        ActiveMQBytesMessageReaderTest.assertTrue((msg.getPacketType() == 9 ? 1 : 0) != 0);
    }

    public void testReadPacket() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQBytesMessageReader reader = new ActiveMQBytesMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQBytesMessageWriter writer = new ActiveMQBytesMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQBytesMessage msg1 = new ActiveMQBytesMessage();
        try {
            msg1.setBodyAsBytes(this.testdata, 0, this.testdata.length);
            super.initializeMessage((ActiveMQMessage)msg1);
            byte[] data = writer.writePacketToByteArray((Packet)msg1);
            ActiveMQBytesMessage msg2 = (ActiveMQBytesMessage)reader.readPacketFromByteArray(data);
            super.testEquals((ActiveMQMessage)msg1, (ActiveMQMessage)msg2);
            ByteArray d2 = msg2.getBodyAsBytes();
            ActiveMQBytesMessageReaderTest.assertTrue((d2.getLength() == this.testdata.length ? 1 : 0) != 0);
            for (int i = 0; i < this.testdata.length; ++i) {
                ActiveMQBytesMessageReaderTest.assertTrue((d2.get(i) == this.testdata[i] ? 1 : 0) != 0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ActiveMQBytesMessageReaderTest.assertTrue((boolean)false);
        }
    }

    public void testTime() {
        DefaultWireFormat wf = new DefaultWireFormat();
        ActiveMQBytesMessageReader reader = new ActiveMQBytesMessageReader((AbstractDefaultWireFormat)wf);
        ActiveMQBytesMessageWriter writer = new ActiveMQBytesMessageWriter((AbstractDefaultWireFormat)wf);
        ActiveMQBytesMessage msg1 = new ActiveMQBytesMessage();
        ActiveMQBytesMessage msg2 = null;
        try {
            int count = 10000;
            long startTime = System.currentTimeMillis();
            msg1.setBodyAsBytes(this.testdata, 0, this.testdata.length);
            super.initializeMessage((ActiveMQMessage)msg1);
            for (int i = 0; i < count; ++i) {
                byte[] data = writer.writePacketToByteArray((Packet)msg1);
                msg2 = (ActiveMQBytesMessage)reader.readPacketFromByteArray(data);
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            long ps = (long)(count * 1000) / totalTime;
            System.out.println("Time taken :" + totalTime + " for " + count + "iterations, = " + ps + " per sec.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ActiveMQBytesMessageReaderTest.assertTrue((boolean)false);
        }
    }
}

