/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.jms.Message;
import junit.framework.TestCase;
import org.activemq.filter.Expression;
import org.activemq.filter.ExpressionFilter;
import org.activemq.filter.MultiExpressionEvaluator;
import org.activemq.message.ActiveMQMessage;
import org.activemq.selector.SelectorParser;

public class MultiExpressionEvaluatorTest
extends TestCase {
    MultiExpressionEvaluator evaluator = new MultiExpressionEvaluator();
    ArrayList expressions = new ArrayList();
    public static final int SPEED_TEST_ITERATIONS = 100000;

    protected void setUp() throws Exception {
        this.expressions.add(this.parseTrue("(3+4=7 AND 3+4=7) OR 1=10"));
        this.expressions.add(this.parseTrue("(3+4=7 AND 3+4=7) AND 3+4=7"));
        this.expressions.add(this.parseTrue("(3+4)*10=70"));
        this.expressions.add(this.parseTrue("((3+4=7 AND 3+4=7) OR 1=10) AND 10 BETWEEN 0 AND 100"));
        this.expressions.add(this.parseFalse("(3+4)*5=70"));
        this.expressions.add(this.parseTrue("10 BETWEEN 0 AND 100"));
        this.expressions.add(this.parseFalse("((3+4=7 OR 3+4=7) OR 1=10) AND 1=10"));
    }

    private Expression parseTrue(String string) throws Exception {
        Expression rc = this.parse(string);
        MultiExpressionEvaluatorTest.assertEquals((Object)rc.evaluate((Message)new ActiveMQMessage()), (Object)Boolean.TRUE);
        return rc;
    }

    private Expression parseFalse(String string) throws Exception {
        Expression rc = this.parse(string);
        MultiExpressionEvaluatorTest.assertEquals((Object)rc.evaluate((Message)new ActiveMQMessage()), (Object)Boolean.FALSE);
        return rc;
    }

    protected Expression parse(String text) throws Exception {
        ExpressionFilter filter = (ExpressionFilter)new SelectorParser().parse(text);
        return filter.getExpression();
    }

    public void testSimpleEvaluation() {
        final int[] hits = new int[]{0};
        boolean[] test = new boolean[]{true};
        Iterator i = this.expressions.iterator();
        while (i.hasNext()) {
            Expression expr = (Expression)i.next();
            this.evaluator.addExpressionListner(expr, new MultiExpressionEvaluator.ExpressionListener(){

                public void evaluateResultEvent(Expression selector, Message message, Object result) {
                    hits[0] = result.equals(Boolean.TRUE) ? hits[0] + 1 : hits[0] - 1;
                }
            });
        }
        this.evaluator.evaluate((Message)new ActiveMQMessage());
        MultiExpressionEvaluatorTest.assertTrue((hits[0] == 3 ? 1 : 0) != 0);
    }

    public void testSpeedUsingMultiExpressionEvaluator() {
        Iterator i = this.expressions.iterator();
        while (i.hasNext()) {
            Expression expr = (Expression)i.next();
            this.evaluator.addExpressionListner(expr, new MultiExpressionEvaluator.ExpressionListener(){

                public void evaluateResultEvent(Expression selector, Message message, Object result) {
                }
            });
        }
        ActiveMQMessage message = new ActiveMQMessage();
        long start = System.currentTimeMillis();
        for (int i2 = 0; i2 < 100000; ++i2) {
            this.evaluator.evaluate((Message)message);
        }
        long end = System.currentTimeMillis();
        this.printSpeedReport("Using MultiExpressionEvaluator", start, end);
    }

    public void testSpeedNotUsingMultiExpressionEvaluator() {
        Expression[] expr = new Expression[this.expressions.size()];
        this.expressions.toArray(expr);
        ActiveMQMessage message = new ActiveMQMessage();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            for (int j = 0; j < expr.length; ++j) {
                try {
                    expr[j].evaluate((Message)message);
                    continue;
                }
                catch (JMSException e) {
                    // empty catch block
                }
            }
        }
        long end = System.currentTimeMillis();
        this.printSpeedReport("Not Using MultiExpressionEvaluator", start, end);
    }

    private void printSpeedReport(String testName, long start, long end) {
        System.out.println("Duration: " + testName + ": " + (double)(end - start) / 1000.0 + " seconds.");
        System.out.println("Evaluation Rate: " + testName + ": " + (float)(100000 * this.expressions.size()) / (float)(end - start) + " evaluations/second.");
    }
}

