/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import junit.framework.TestCase;
import org.activemq.filter.DestinationPath;

public class DestinationPathTest
extends TestCase {
    public void testPathParse() {
        this.assertParse("FOO", new String[]{"FOO"});
        this.assertParse("FOO.BAR", new String[]{"FOO", "BAR"});
        this.assertParse("FOO.*", new String[]{"FOO", "*"});
        this.assertParse("FOO.>", new String[]{"FOO", ">"});
        this.assertParse("FOO.BAR.XYZ", new String[]{"FOO", "BAR", "XYZ"});
        this.assertParse("FOO.BAR.", new String[]{"FOO", "BAR", ""});
    }

    protected void assertParse(String subject, String[] expected) {
        Object[] path = DestinationPath.getDestinationPaths((String)subject);
        this.assertArrayEqual(subject, expected, path);
    }

    protected void assertArrayEqual(String message, Object[] expected, Object[] actual) {
        DestinationPathTest.assertEquals((String)(message + ". Array length"), (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            DestinationPathTest.assertEquals((String)(message + ". element: " + i), (Object)expected[i], (Object)actual[i]);
        }
    }
}

