/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.DestinationFilter;
import org.activemq.filter.Filter;
import org.activemq.message.ActiveMQMessage;
import org.activemq.test.TestSupport;

public class DestinationFilterTest
extends TestSupport {
    public void testNonWildcard() throws JMSException {
        Filter filter = this.createFilter("FOO.BAR");
        this.assertFilterMatches(filter, "FOO.BAR", true);
        this.assertFilterMatches(filter, "FOO.BA", false);
        this.assertFilterMatches(filter, "FOO.BAR.", false);
        this.assertFilterMatches(filter, "FOO.BAR.Y", false);
        this.assertFilterMatches(filter, "FOO", false);
    }

    public void testPrefixWildcard() throws JMSException {
        Filter filter = this.createFilter("FOO.>");
        this.assertFilterMatches(filter, "FOO.BAR", true);
        this.assertFilterMatches(filter, "FOO.BA", true);
        this.assertFilterMatches(filter, "FOO.BAR.", true);
        this.assertFilterMatches(filter, "FOO.BAR.Y", true);
        this.assertFilterMatches(filter, "FOO", false);
        this.assertFilterMatches(filter, "BAR.BAR", false);
    }

    public void testTwoLevelPrefixWildcard() throws JMSException {
        Filter filter = this.createFilter("FOO.BAR.>");
        this.assertFilterMatches(filter, "FOO.BAR", false);
        this.assertFilterMatches(filter, "FOO.BAR.FOO", true);
        this.assertFilterMatches(filter, "FOO.BAR.FOO.WHATNOT", true);
        this.assertFilterMatches(filter, "FOO.XAR.FOO", false);
    }

    public void testMatchAnythingWildcard() throws JMSException {
        Filter filter = this.createFilter(">");
        this.assertFilterMatches(filter, "FOO.BAR", true);
        this.assertFilterMatches(filter, "FOO.BA", true);
        this.assertFilterMatches(filter, "FOO.BAR.", true);
        this.assertFilterMatches(filter, "FOO.BAR.Y", true);
        this.assertFilterMatches(filter, "", true);
        this.assertFilterMatches(filter, "FOO", true);
        this.assertFilterMatches(filter, "BAR.BAR", true);
    }

    public void testWildcard() throws JMSException {
        Filter filter = this.createFilter("FOO.*");
        this.assertFilterMatches(filter, "FOO.BAR", true);
        this.assertFilterMatches(filter, "FOO.BA", true);
        this.assertFilterMatches(filter, "FOO.BAR.", false);
        this.assertFilterMatches(filter, "FOO.BAR.Y", false);
        this.assertFilterMatches(filter, "FOO", false);
        this.assertFilterMatches(filter, "BAR.BAR", false);
    }

    public void testDoubleWildcard() throws JMSException {
        Filter filter = this.createFilter("FOO.*.*");
        this.assertFilterMatches(filter, "FOO.BAR", false);
        this.assertFilterMatches(filter, "FOO.BAR.XYZ", true);
        this.assertFilterMatches(filter, "FOO.BAR.", true);
        this.assertFilterMatches(filter, "FOO.BAR.XYZ.", false);
        this.assertFilterMatches(filter, "FOO.BAR.XYZ.ZZZ", false);
        this.assertFilterMatches(filter, "FOO", false);
        this.assertFilterMatches(filter, "BAR.BAR", false);
    }

    public void testWildcardInMiddle() throws JMSException {
        Filter filter = this.createFilter("FOO.*.XYZ");
        this.assertFilterMatches(filter, "FOO.BAR", false);
        this.assertFilterMatches(filter, "FOO.BAR.XYZ", true);
        this.assertFilterMatches(filter, "FOO..XYZ", true);
        this.assertFilterMatches(filter, "FOO.WHATEVER.XYZ", true);
        this.assertFilterMatches(filter, "FOO.BAR.XYZ.", false);
        this.assertFilterMatches(filter, "FOO.BAR.XYZ.ZZZ", false);
        this.assertFilterMatches(filter, "FOO", false);
        this.assertFilterMatches(filter, "BAR.BAR", false);
    }

    public void testIntermixedWildcards() throws JMSException {
        Filter filter = this.createFilter("FOO.*.ABC.*");
        this.assertFilterMatches(filter, "FOO.BAR", false);
        this.assertFilterMatches(filter, "FOO.BAR.ABC", false);
        this.assertFilterMatches(filter, "FOO.BAR.ABC.DEF", true);
        this.assertFilterMatches(filter, "FOO..ABC.DEF", true);
        this.assertFilterMatches(filter, "FOO..ABC.", true);
        this.assertFilterMatches(filter, "FOO.BAR.ABC.DEF.", false);
        this.assertFilterMatches(filter, "FOO.BAR.ABC.DEF.X", false);
        this.assertFilterMatches(filter, "FOO.BAR.ABC", false);
        this.assertFilterMatches(filter, "FOO.BAR.XYZ.", false);
        this.assertFilterMatches(filter, "FOO.BAR.XYZ.ZZZ", false);
        this.assertFilterMatches(filter, "FOO", false);
        this.assertFilterMatches(filter, "BAR.BAR", false);
    }

    public void testCompositeFilter() throws JMSException {
        Filter filter = this.createFilter("FOO.BAR.ABC.DEF,FOO.XYZ");
        this.assertFilterMatches(filter, "FOO.XYZ", true);
        this.assertFilterMatches(filter, "FOO.BAR", false);
        this.assertFilterMatches(filter, "FOO.BAR.ABC", false);
        this.assertFilterMatches(filter, "FOO.BAR.ABC.DEF", true);
        this.assertFilterMatches(filter, "FOO.BAR.ABC.DEF.", false);
        this.assertFilterMatches(filter, "FOO.BAR.ABC.DEF.X", false);
        this.assertFilterMatches(filter, "FOO.BAR.ABC", false);
        this.assertFilterMatches(filter, "FOO.BAR.XYZ.", false);
        this.assertFilterMatches(filter, "FOO.BAR.XYZ.ZZZ", false);
        this.assertFilterMatches(filter, "FOO", false);
        this.assertFilterMatches(filter, "BAR.BAR", false);
    }

    protected void assertFilterMatches(Filter filter, String subject, boolean expected) throws JMSException {
        Destination destination = this.createDestination(subject);
        ActiveMQMessage message = this.createMessage();
        message.setJMSDestination(destination);
        boolean actual = filter.matches((Message)message);
        DestinationFilterTest.assertEquals((String)("Matching " + filter + " to: " + destination), (boolean)expected, (boolean)actual);
    }

    protected Filter createFilter(String subject) {
        return DestinationFilter.parseFilter((Destination)this.createDestination(subject));
    }
}

