/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.bug;

import EDU.oswego.cs.dl.util.concurrent.CountDown;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;

public class AMQ336Test
extends TestCase {
    CountDown outstandingMessages = new CountDown(3);
    Inbox in;

    protected void setUp() throws Exception {
        this.in = new Inbox();
    }

    protected void tearDown() throws Exception {
        if (this.in != null) {
            this.in.stop();
        }
    }

    public void testDeadlock() throws Exception {
        this.in.receive(2);
        this.in.receive(1);
        this.in.receive(3);
        this.in.startDeliveringMessages();
        this.outstandingMessages.attempt(5000L);
        AMQ336Test.assertEquals((int)0, (int)this.outstandingMessages.currentCount());
    }

    class Inbox
    implements MessageListener {
        private final ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        private Connection connection = this.connectionFactory.createConnection();
        private Session session;
        private Queue destination;
        private MessageProducer producer;
        private MessageConsumer consumer;
        private final boolean durable = false;
        private String clientID = "clientid";

        public Inbox() throws JMSException {
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.destination = this.session.createQueue("subject");
            this.producer = this.session.createProducer((Destination)this.destination);
            this.producer.setDeliveryMode(1);
            this.consumer = this.session.createConsumer((Destination)this.destination);
        }

        public void stop() throws JMSException {
            if (this.consumer != null) {
                this.consumer.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }

        public void receive(int message) throws JMSException {
            ObjectMessage jmsMsg = this.session.createObjectMessage((Serializable)new Integer(message));
            this.producer.send((Message)jmsMsg);
        }

        public void startDeliveringMessages() throws JMSException {
            this.consumer.setMessageListener((MessageListener)this);
        }

        public void onMessage(Message arg0) {
            AMQ336Test.this.outstandingMessages.release();
        }
    }
}

