/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.impl;

import junit.framework.TestCase;
import org.activemq.broker.impl.AdvisorySupport;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.ConnectionInfo;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.ProducerInfo;

public class AdvisorySupportTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public AdvisorySupportTest(String arg0) {
        super(arg0);
    }

    public void testMatchConsumer() {
        String destName = "foo.bar";
        ActiveMQTopic topic = new ActiveMQTopic(destName);
        ConsumerInfo info = new ConsumerInfo();
        info.setDestination((ActiveMQDestination)topic);
        ActiveMQTopic advisoryDest = topic.getTopicForConsumerAdvisory();
        ConsumerInfo advisory = new ConsumerInfo();
        advisory.setDestination((ActiveMQDestination)advisoryDest);
        AdvisorySupport test = new AdvisorySupport(null);
        AdvisorySupportTest.assertTrue((boolean)test.matchConsumer(advisory, info));
    }

    public void testMatchProducer() {
        String destName = "foo.bar";
        ActiveMQTopic topic = new ActiveMQTopic(destName);
        ProducerInfo info = new ProducerInfo();
        info.setDestination((ActiveMQDestination)topic);
        ActiveMQTopic advisoryDest = topic.getTopicForProducerAdvisory();
        ConsumerInfo advisory = new ConsumerInfo();
        advisory.setDestination((ActiveMQDestination)advisoryDest);
        AdvisorySupport test = new AdvisorySupport(null);
        AdvisorySupportTest.assertTrue((boolean)test.matchProducer(advisory, info));
    }

    public void testMatchConnection() {
        ConnectionInfo info = new ConnectionInfo();
        ActiveMQTopic advisoryDest = new ActiveMQTopic("ActiveMQ.Advisory.Connections.");
        ConsumerInfo advisory = new ConsumerInfo();
        advisory.setDestination((ActiveMQDestination)advisoryDest);
        AdvisorySupport test = new AdvisorySupport(null);
        AdvisorySupportTest.assertTrue((boolean)test.matchConnection(advisory, info));
    }
}

