/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import javax.jms.JMSException;
import org.activemq.broker.BrokerAdmin;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.impl.BrokerContainerImpl;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQQueue;
import org.activemq.service.MessageContainerAdmin;
import org.activemq.test.TestSupport;

public class BrokerAdminTest
extends TestSupport {
    private static final String TEST_QUEUE_NAME = "TestQueue";
    public static final String URL = "tcp://localhost:61616";
    protected BrokerContainer container;

    protected void setUp() throws Exception {
        this.container = new BrokerContainerImpl(URL);
        this.container.start();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.container.stop();
    }

    public void testInitialState() throws JMSException {
        BrokerAdmin brokerAdmin = this.getBrokerAdmin();
        MessageContainerAdmin[] admins = brokerAdmin.listMessageContainerAdmin();
        BrokerAdminTest.assertEquals((int)0, (int)admins.length);
    }

    public void testCreateQueue() throws JMSException {
        BrokerAdmin brokerAdmin = this.getBrokerAdmin();
        brokerAdmin.createMessageContainer((ActiveMQDestination)new ActiveMQQueue(TEST_QUEUE_NAME));
        MessageContainerAdmin[] admins = brokerAdmin.listMessageContainerAdmin();
        BrokerAdminTest.assertEquals((int)1, (int)admins.length);
        BrokerAdminTest.assertEquals((String)admins[0].getDestinationName(), (String)TEST_QUEUE_NAME);
    }

    public void testDeleteQueue() throws JMSException {
        BrokerAdmin brokerAdmin = this.getBrokerAdmin();
        brokerAdmin.createMessageContainer((ActiveMQDestination)new ActiveMQQueue(TEST_QUEUE_NAME));
        brokerAdmin.destoryMessageContainer((ActiveMQDestination)new ActiveMQQueue(TEST_QUEUE_NAME));
        MessageContainerAdmin[] admins = brokerAdmin.listMessageContainerAdmin();
        BrokerAdminTest.assertEquals((int)0, (int)admins.length);
    }

    private BrokerAdmin getBrokerAdmin() {
        return this.container.getBroker().getBrokerAdmin();
    }
}

