/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.advisories.ProducerAdvisoryEvent;
import org.activemq.advisories.TempDestinationAdvisor;
import org.activemq.message.ProducerInfo;

public class TempDestinationAdvisorTest
extends TestCase {
    private ActiveMQConnectionFactory fac;
    private Connection connection;
    private SynchronizedBoolean started;

    protected void setUp() throws Exception {
        this.started = new SynchronizedBoolean(false);
        this.fac = new ActiveMQConnectionFactory("vm://localhost");
        this.connection = this.fac.createConnection();
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
    }

    public void testAdvisories() throws Exception {
        Connection testCon = this.fac.createConnection();
        testCon.start();
        Session s = testCon.createSession(false, 1);
        TemporaryQueue dest = s.createTemporaryQueue();
        TempDestinationAdvisor test = new TempDestinationAdvisor(this.connection, (Destination)dest);
        test.start();
        TempDestinationAdvisorTest.assertTrue((String)"Destination should be active", (boolean)test.isActive((Destination)dest));
        dest.delete();
        TempDestinationAdvisorTest.assertFalse((String)"Destination should no longer be active", (boolean)test.isActive((Destination)dest));
        test.stop();
        testCon = this.fac.createConnection();
        testCon.start();
        s = testCon.createSession(false, 1);
        dest = s.createTemporaryQueue();
        test = new TempDestinationAdvisor(this.connection, (Destination)dest);
        test.start();
        TempDestinationAdvisorTest.assertTrue((boolean)test.isActive((Destination)dest));
        testCon.close();
        TempDestinationAdvisorTest.assertFalse((boolean)test.isActive((Destination)dest));
        test.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(ProducerAdvisoryEvent event) {
        ProducerInfo info = event.getInfo();
        this.started.set(info.isStarted());
        SynchronizedBoolean synchronizedBoolean = this.started;
        synchronized (synchronizedBoolean) {
            this.started.notify();
        }
    }
}

