/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.WaitableBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.advisories.ProducerDemandAdvisor;
import org.activemq.advisories.ProducerDemandEvent;
import org.activemq.advisories.ProducerDemandListener;

public class ProducerDemandAdvisorTest
extends TestCase
implements ProducerDemandListener {
    private Connection connection;
    private Session session;
    private Destination destination;
    private String destinationName = "foo.bar";
    private WaitableBoolean inDemand = new WaitableBoolean(false);

    protected void setUp() throws Exception {
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory("vm://localhost");
        this.connection = fac.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.destination = this.session.createTopic(this.destinationName);
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
    }

    public void testAdvisories() throws Exception {
        ProducerDemandAdvisor advisor = new ProducerDemandAdvisor(this.connection, this.destination);
        advisor.setDemandListener((ProducerDemandListener)this);
        advisor.start();
        this.assertDemandChange(false, 2000L);
        MessageConsumer consumer = this.session.createConsumer(this.destination);
        this.assertDemandChange(true, 2000L);
        this.session.close();
        this.assertDemandChange(false, 5000L);
    }

    public void testAdvisoriesWhenConsumerAllreadyExists() throws Exception {
        MessageConsumer consumer = this.session.createConsumer(this.destination);
        ProducerDemandAdvisor advisor = new ProducerDemandAdvisor(this.connection, this.destination);
        advisor.setDemandListener((ProducerDemandListener)this);
        advisor.start();
        this.assertDemandChange(true, 2000L);
        this.session.close();
        this.assertDemandChange(false, 2000L);
    }

    public void assertDemandChange(final boolean value, long timeout) {
        final Latch change = new Latch();
        try {
            new Thread(){

                public void run() {
                    try {
                        ProducerDemandAdvisorTest.this.inDemand.whenEqual(value, new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                1.access$000(this.this$1).release();
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }

                static /* synthetic */ Latch access$000(1 x0) {
                    return x0.change;
                }
            }.start();
            ProducerDemandAdvisorTest.assertTrue((String)("Demand did not change to: " + value), (boolean)change.attempt(timeout));
        }
        catch (InterruptedException e) {
            ProducerDemandAdvisorTest.fail((String)("Interuppted: " + e));
        }
    }

    public void onEvent(ProducerDemandEvent event) {
        this.inDemand.set(event.isInDemand());
    }
}

