/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.advisories.ProducerAdvisor;
import org.activemq.advisories.ProducerAdvisoryEvent;
import org.activemq.advisories.ProducerAdvisoryEventListener;
import org.activemq.message.ProducerInfo;

public class ProducerAdvisorTest
extends TestCase
implements ProducerAdvisoryEventListener {
    private Connection connection;
    private Session session;
    private Destination destination;
    private String destinationName = "foo.bar";
    private SynchronizedBoolean started;

    protected void setUp() throws Exception {
        this.started = new SynchronizedBoolean(false);
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory("vm://localhost");
        this.connection = fac.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.destination = this.session.createTopic(this.destinationName);
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdvisories() throws Exception {
        ProducerAdvisor test = new ProducerAdvisor(this.connection, this.destination);
        test.addListener((ProducerAdvisoryEventListener)this);
        test.start();
        MessageProducer producer = this.session.createProducer(this.destination);
        SynchronizedBoolean synchronizedBoolean = this.started;
        synchronized (synchronizedBoolean) {
            if (!this.started.get()) {
                this.started.wait(2000L);
            }
        }
        ProducerAdvisorTest.assertTrue((boolean)this.started.get());
        this.session.close();
        synchronizedBoolean = this.started;
        synchronized (synchronizedBoolean) {
            if (this.started.get()) {
                this.started.wait(2000L);
            }
        }
        ProducerAdvisorTest.assertFalse((boolean)this.started.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(ProducerAdvisoryEvent event) {
        ProducerInfo info = event.getInfo();
        this.started.set(info.isStarted());
        SynchronizedBoolean synchronizedBoolean = this.started;
        synchronized (synchronizedBoolean) {
            this.started.notify();
        }
    }
}

