/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.advisories.ConsumerAdvisor;
import org.activemq.advisories.ConsumerAdvisoryEvent;
import org.activemq.advisories.ConsumerAdvisoryEventListener;
import org.activemq.message.ConsumerInfo;

public class ConsumerAdvisorTest
extends TestCase
implements ConsumerAdvisoryEventListener {
    private Connection connection;
    private Session session;
    private Destination destination;
    private String destinationName = "foo.bar";
    private SynchronizedBoolean started;

    protected void setUp() throws Exception {
        this.started = new SynchronizedBoolean(false);
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory("vm://localhost");
        this.connection = fac.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.destination = this.session.createTopic(this.destinationName);
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdvisories() throws Exception {
        ConsumerAdvisor test = new ConsumerAdvisor(this.connection, this.destination);
        test.addListener((ConsumerAdvisoryEventListener)this);
        test.start();
        MessageConsumer consumer = this.session.createConsumer(this.destination);
        SynchronizedBoolean synchronizedBoolean = this.started;
        synchronized (synchronizedBoolean) {
            if (!this.started.get()) {
                this.started.wait(2000L);
            }
        }
        ConsumerAdvisorTest.assertTrue((boolean)this.started.get());
        this.session.close();
        synchronizedBoolean = this.started;
        synchronized (synchronizedBoolean) {
            if (this.started.get()) {
                this.started.wait(2000L);
            }
        }
        ConsumerAdvisorTest.assertFalse((boolean)this.started.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(ConsumerAdvisoryEvent event) {
        ConsumerInfo info = event.getInfo();
        this.started.set(info.isStarted());
        SynchronizedBoolean synchronizedBoolean = this.started;
        synchronized (synchronizedBoolean) {
            this.started.notify();
        }
    }
}

