/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import javax.jms.Connection;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.advisories.ConnectionAdvisor;
import org.activemq.advisories.ConnectionAdvisoryEvent;
import org.activemq.advisories.ConnectionAdvisoryEventListener;
import org.activemq.message.ConnectionInfo;

public class ConnectionAdvisorTest
extends TestCase
implements ConnectionAdvisoryEventListener {
    private ActiveMQConnectionFactory fac;
    private Connection connection;
    private SynchronizedBoolean started;

    protected void setUp() throws Exception {
        this.started = new SynchronizedBoolean(false);
        this.fac = new ActiveMQConnectionFactory("vm://localhost");
        this.connection = this.fac.createConnection();
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdvisories() throws Exception {
        ConnectionAdvisor test = new ConnectionAdvisor(this.connection);
        test.addListener((ConnectionAdvisoryEventListener)this);
        test.start();
        Connection testConnection = this.fac.createConnection();
        testConnection.start();
        SynchronizedBoolean synchronizedBoolean = this.started;
        synchronized (synchronizedBoolean) {
            if (!this.started.get()) {
                this.started.wait(5000L);
            }
        }
        ConnectionAdvisorTest.assertTrue((boolean)this.started.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(ConnectionAdvisoryEvent event) {
        System.out.println(event);
        ConnectionInfo info = event.getInfo();
        this.started.set(info.isStarted());
        SynchronizedBoolean synchronizedBoolean = this.started;
        synchronized (synchronizedBoolean) {
            this.started.notify();
        }
    }
}

