/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import java.io.File;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestSupport
extends TestCase {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected ActiveMQConnectionFactory connectionFactory;
    protected boolean topic = true;

    public TestSupport() {
    }

    public TestSupport(String name) {
        super(name);
    }

    protected ActiveMQMessage createMessage() {
        return new ActiveMQMessage();
    }

    protected Destination createDestination(String subject) {
        if (this.topic) {
            return new ActiveMQTopic(subject);
        }
        return new ActiveMQQueue(subject);
    }

    protected void assertTextMessagesEqual(String messsage, Message[] firstSet, Message[] secondSet) throws JMSException {
        TestSupport.assertEquals((String)("Message count does not match: " + messsage), (int)firstSet.length, (int)secondSet.length);
        for (int i = 0; i < secondSet.length; ++i) {
            TextMessage m1 = (TextMessage)firstSet[i];
            TextMessage m2 = (TextMessage)secondSet[i];
            TestSupport.assertFalse((String)("Message " + (i + 1) + " did not match : " + messsage + ": expected {" + m1 + "}, but was {" + m2 + "}"), (boolean)(m1 == null ^ m2 == null));
            TestSupport.assertEquals((String)("Message " + (i + 1) + " did not match: " + messsage + ": expected {" + m1 + "}, but was {" + m2 + "}"), (String)m1.getText(), (String)m2.getText());
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost");
    }

    protected Connection createConnection() throws Exception {
        return this.getConnectionFactory().createConnection();
    }

    public ActiveMQConnectionFactory getConnectionFactory() throws Exception {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
            TestSupport.assertTrue((String)"Should have created a connection factory!", (this.connectionFactory != null ? 1 : 0) != 0);
        }
        return this.connectionFactory;
    }

    protected String getConsumerSubject() {
        return this.getSubject();
    }

    protected String getProducerSubject() {
        return this.getSubject();
    }

    protected String getSubject() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    public static void recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                TestSupport.recursiveDelete(files[i]);
            }
        }
        f.delete();
    }

    public static void removeMessageStore() {
        if (System.getProperty("activemq.store.dir") != null) {
            TestSupport.recursiveDelete(new File(System.getProperty("activemq.store.dir")));
        }
        if (System.getProperty("derby.system.home") != null) {
            TestSupport.recursiveDelete(new File(System.getProperty("derby.system.home")));
        }
    }
}

