/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQPrefetchPolicy;
import org.activemq.test.JmsResourceProvider;
import org.activemq.test.TestSupport;

public abstract class JmsTransactionTestSupport
extends TestSupport {
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected JmsResourceProvider resourceProvider;
    protected Destination destination;

    public JmsTransactionTestSupport() {
    }

    public JmsTransactionTestSupport(String name) {
        super(name);
    }

    public void testSendReceiveTransactedBatches() throws Exception {
        int batchCount = 10;
        int batchSize = 20;
        TextMessage message = this.session.createTextMessage("Batch Message");
        for (int j = 0; j < batchCount; ++j) {
            int i;
            System.out.println("Producing bacth " + j + " of " + batchSize + " messages");
            for (i = 0; i < batchSize; ++i) {
                this.producer.send((Message)message);
            }
            this.session.commit();
            System.out.println("Consuming bacth " + j + " of " + batchSize + " messages");
            for (i = 0; i < batchSize; ++i) {
                message = (TextMessage)this.consumer.receive(5000L);
                JmsTransactionTestSupport.assertNotNull((String)("Received only " + i + " messages in batch " + j), (Object)message);
                JmsTransactionTestSupport.assertEquals((String)"Batch Message", (String)message.getText());
            }
            this.session.commit();
        }
    }

    public void testSendRollback() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.producer.send(outbound[0]);
        this.session.commit();
        this.producer.send((Message)this.session.createTextMessage("I'm going to get rolled back."));
        this.session.rollback();
        this.producer.send(outbound[1]);
        this.session.commit();
        ArrayList<Message> messages = new ArrayList<Message>();
        System.out.println("About to consume message 1");
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        System.out.println("Received: " + message);
        System.out.println("About to consume message 2");
        message = this.consumer.receive(4000L);
        messages.add(message);
        System.out.println("Received: " + message);
        this.session.commit();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work.", outbound, inbound);
    }

    public void testReceiveRollback() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        while (this.consumer.receive(1000L) != null) {
        }
        this.session.commit();
        this.producer.send(outbound[0]);
        this.producer.send(outbound[1]);
        this.session.commit();
        System.out.println("Sent 0: " + outbound[0]);
        System.out.println("Sent 1: " + outbound[1]);
        ArrayList<Message> messages = new ArrayList<Message>();
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        this.assertEquals(outbound[0], message);
        this.session.commit();
        message = this.consumer.receive(1000L);
        JmsTransactionTestSupport.assertNotNull((Object)message);
        this.assertEquals(outbound[1], message);
        this.session.rollback();
        message = this.consumer.receive(5000L);
        JmsTransactionTestSupport.assertNotNull((String)"Should have re-received the message again!", (Object)message);
        messages.add(message);
        this.session.commit();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work", outbound, inbound);
    }

    public void testReceiveTwoThenRollback() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        while (this.consumer.receive(1000L) != null) {
        }
        this.session.commit();
        this.producer.send(outbound[0]);
        this.producer.send(outbound[1]);
        this.session.commit();
        System.out.println("Sent 0: " + outbound[0]);
        System.out.println("Sent 1: " + outbound[1]);
        ArrayList<Message> messages = new ArrayList<Message>();
        Message message = this.consumer.receive(1000L);
        this.assertEquals(outbound[0], message);
        message = this.consumer.receive(1000L);
        JmsTransactionTestSupport.assertNotNull((Object)message);
        this.assertEquals(outbound[1], message);
        this.session.rollback();
        message = this.consumer.receive(5000L);
        JmsTransactionTestSupport.assertNotNull((String)"Should have re-received the first message again!", (Object)message);
        messages.add(message);
        this.assertEquals(outbound[0], message);
        message = this.consumer.receive(5000L);
        JmsTransactionTestSupport.assertNotNull((String)"Should have re-received the second message again!", (Object)message);
        messages.add(message);
        this.assertEquals(outbound[1], message);
        this.session.commit();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work", outbound, inbound);
    }

    public void testReceiveTwoThenRollbackManyTimes() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.testReceiveTwoThenRollback();
        }
    }

    public void testSendRollbackWithPrefetchOfOne() throws Exception {
        this.setPrefetchToOne();
        this.testSendRollback();
    }

    public void testReceiveRollbackWithPrefetchOfOne() throws Exception {
        this.setPrefetchToOne();
        this.testReceiveRollback();
    }

    public void testCloseConsumerBeforeCommit() throws Exception {
        TextMessage[] outbound = new TextMessage[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        while (this.consumer.receive(1000L) != null) {
        }
        this.session.commit();
        this.producer.send((Message)outbound[0]);
        this.producer.send((Message)outbound[1]);
        this.session.commit();
        System.out.println("Sent 0: " + outbound[0]);
        System.out.println("Sent 1: " + outbound[1]);
        ArrayList messages = new ArrayList();
        TextMessage message = (TextMessage)this.consumer.receive(1000L);
        JmsTransactionTestSupport.assertEquals((String)outbound[0].getText(), (String)message.getText());
        this.consumer.close();
        this.session.commit();
        this.consumer = this.resourceProvider.createConsumer(this.session, this.destination);
        System.out.println("Created consumer: " + this.consumer);
        message = (TextMessage)this.consumer.receive(1000L);
        JmsTransactionTestSupport.assertEquals((String)outbound[1].getText(), (String)message.getText());
        this.session.commit();
    }

    protected abstract JmsResourceProvider getJmsResourceProvider();

    protected void setUp() throws Exception {
        super.setUp();
        this.resourceProvider = this.getJmsResourceProvider();
        this.topic = this.resourceProvider.isTopic();
        this.resourceProvider.setTransacted(true);
        this.connectionFactory = this.resourceProvider.createConnectionFactory();
        this.reconnect();
    }

    protected void reconnect() throws JMSException {
        Connection t = this.resourceProvider.createConnection(this.connectionFactory);
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = t;
        this.session = this.resourceProvider.createSession(this.connection);
        this.destination = this.resourceProvider.createDestination(this.session, this.getSubject());
        this.producer = this.resourceProvider.createProducer(this.session, this.destination);
        this.consumer = this.resourceProvider.createConsumer(this.session, this.destination);
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        System.out.println("Closing down connection");
        this.session.close();
        this.connection.close();
        System.out.println("Connection closed.");
    }

    protected void setPrefetchToOne() {
        ActiveMQPrefetchPolicy prefetchPolicy = ((ActiveMQConnection)this.connection).getPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(1);
        prefetchPolicy.setTopicPrefetch(1);
        prefetchPolicy.setDurableTopicPrefetch(1);
    }
}

