/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.activemq.JmsSendReceiveTestSupport;
import org.activemq.util.IndentPrinter;

public class JmsTopicSendReceiveTest
extends JmsSendReceiveTestSupport {
    protected Connection connection;

    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        if (this.durable) {
            this.connection.setClientID(((Object)((Object)this)).getClass().getName());
        }
        System.out.println("Created connection: " + this.connection);
        this.session = this.connection.createSession(false, 1);
        System.out.println("Created session: " + this.session);
        this.producer = this.session.createProducer(null);
        this.producer.setDeliveryMode(this.deliveryMode);
        System.out.println("Created producer: " + this.producer + " delivery mode = " + (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT"));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        System.out.println("Created  consumer destination: " + this.consumerDestination + " of type: " + this.consumerDestination.getClass());
        System.out.println("Created  producer destination: " + this.producerDestination + " of type: " + this.producerDestination.getClass());
        this.consumer = this.createConsumer();
        this.consumer.setMessageListener((MessageListener)this);
        this.connection.start();
        System.out.println("Created connection: " + this.connection);
    }

    protected MessageConsumer createConsumer() throws JMSException {
        if (this.durable) {
            System.out.println("Creating durable consumer");
            return this.session.createDurableSubscriber((Topic)this.consumerDestination, this.getName());
        }
        return this.session.createConsumer(this.consumerDestination);
    }

    protected void tearDown() throws Exception {
        System.out.println("Dumping stats...");
        this.connectionFactory.getFactoryStats().dump(new IndentPrinter());
        System.out.println("Closing down connection");
        this.session.close();
        this.connection.close();
    }
}

