/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicRequestor;
import javax.jms.TopicSession;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.advisories.ConnectionAdvisor;
import org.activemq.message.ActiveMQTopic;

public class JmsTopicRequestorTest
extends TestCase
implements MessageListener {
    protected static final int MESSAGE_COUNT = 10;
    protected Connection serverConnection;
    protected TopicConnection requestorConnection;
    protected MessageProducer serverProducer;
    protected Topic destination;

    protected void setUp() throws Exception {
        String root = System.getProperty("activemq.store.dir");
        System.setProperty("activemq.store.dir", root + "_broker_fac1");
        ActiveMQConnectionFactory fac1 = new ActiveMQConnectionFactory("peer://" + ((Object)((Object)this)).getClass().getName() + "?brokerName=server");
        this.serverConnection = fac1.createConnection();
        this.serverConnection.setClientID("server");
        this.serverConnection.start();
        System.setProperty("activemq.store.dir", root + "_broker_fac2");
        ActiveMQConnectionFactory fac2 = new ActiveMQConnectionFactory("peer://" + ((Object)((Object)this)).getClass().getName() + "?brokerName=requestor");
        this.requestorConnection = fac2.createTopicConnection();
        this.requestorConnection.setClientID("requestor");
        String destinationName = ((Object)((Object)this)).getClass().getName();
        this.destination = new ActiveMQTopic(destinationName);
        this.requestorConnection.start();
        Session s = this.serverConnection.createSession(false, 1);
        MessageConsumer mc = s.createConsumer((Destination)this.destination);
        mc.setMessageListener((MessageListener)this);
        this.serverProducer = s.createProducer(null);
    }

    protected void tearDown() throws Exception {
        this.serverConnection.close();
        this.requestorConnection.close();
    }

    public void onMessage(Message msg) {
        try {
            Destination replyTo = msg.getJMSReplyTo();
            this.serverProducer.send(replyTo, msg);
            System.out.println("Server sent reply ...: " + msg);
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
        }
    }

    public void testRequests() throws Exception {
        try {
            TopicSession s = this.requestorConnection.createTopicSession(false, 1);
            TopicRequestor requestor = new TopicRequestor(s, this.destination);
            ConnectionAdvisor ca = new ConnectionAdvisor((Connection)this.requestorConnection);
            ca.start();
            ca.waitForActiveConnections(6, 30000L);
            Iterator i = ca.getConnections().iterator();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
            for (int i2 = 0; i2 < 10; ++i2) {
                TextMessage msg = s.createTextMessage("test:" + i2);
                Message receipt = requestor.request((Message)msg);
                System.out.println("Got reply: " + receipt);
                JmsTopicRequestorTest.assertNotNull((String)"receipt is null!!", (Object)receipt);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

