/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.broker.BrokerContainerFactory;
import org.activemq.broker.impl.BrokerContainerFactoryImpl;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.vm.VMPersistenceAdapter;

public class JmsDurableSubscriptionTest
extends TestCase {
    static /* synthetic */ Class class$org$activemq$store$vm$VMPersistenceAdapterFactory;

    public void testDurableTopic() throws Exception {
        Topics topics1 = new Topics("test", "id1");
        topics1.publish("message1");
        Topics topics2 = new Topics("test", "id3");
        this.assertReceiveEquals(topics2, null);
        topics2.publish("message2");
        this.assertReceiveEquals(topics2, "message2");
        this.assertReceiveEquals(topics2, null);
        topics1.close();
        topics2.close();
    }

    private void assertReceiveEquals(Topics topics3, String text) throws JMSException {
        TextMessage msg = (TextMessage)topics3.receive(1000L);
        if (msg != null) {
            System.out.println("got: " + msg.getText());
        } else {
            System.out.println("got: " + null);
        }
        if (text == null) {
            JmsDurableSubscriptionTest.assertNull((String)("Got:" + msg), (Object)msg);
        } else {
            JmsDurableSubscriptionTest.assertEquals((String)text, (String)msg.getText());
        }
    }

    public static class Topics {
        Connection connection;
        Session session;
        Destination destination;
        MessageConsumer consumer;
        MessageProducer producer;

        public Topics(String name) {
            this(name, String.valueOf(System.currentTimeMillis()));
        }

        public Topics(String name, String clientId) {
            try {
                System.setProperty("activemq.persistenceAdapterFactory", (class$org$activemq$store$vm$VMPersistenceAdapterFactory == null ? (class$org$activemq$store$vm$VMPersistenceAdapterFactory = JmsDurableSubscriptionTest.class$("org.activemq.store.vm.VMPersistenceAdapterFactory")) : class$org$activemq$store$vm$VMPersistenceAdapterFactory).getName());
                ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("defaultUser", "defaultPassword", "peer://burgertime");
                connectionFactory.setBrokerContainerFactory((BrokerContainerFactory)new BrokerContainerFactoryImpl((PersistenceAdapter)new VMPersistenceAdapter()));
                connectionFactory.setUseEmbeddedBroker(true);
                this.connection = connectionFactory.createTopicConnection();
                this.connection.setClientID(clientId);
                this.connection.start();
                this.session = this.connection.createSession(false, 1);
                this.destination = this.session.createTopic(name);
                this.consumer = this.session.createDurableSubscriber((Topic)this.destination, clientId);
                this.producer = this.session.createProducer(this.destination);
                this.producer.setDeliveryMode(2);
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }

        public Message receive(long timeout) throws JMSException {
            return this.consumer.receive(timeout);
        }

        public void publish(String message) {
            try {
                this.producer.send((Message)this.session.createTextMessage(message));
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            try {
                this.consumer.close();
                this.producer.close();
                this.session.close();
                this.connection.close();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

