/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import java.util.Properties;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.broker.Broker;
import org.activemq.broker.impl.BrokerClientImpl;
import org.activemq.transport.vm.VmTransportChannel;

public class EmbeddedBrokerTest
extends TestCase {
    public void testMultipleConnectionFactorysCreateOnlyOneBroker() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        EmbeddedBrokerTest.assertNotNull((Object)connection);
        ActiveMQConnectionFactory factory2 = new ActiveMQConnectionFactory("vm://localhost");
        ActiveMQConnection connection2 = (ActiveMQConnection)factory2.createConnection();
        EmbeddedBrokerTest.assertNotNull((Object)connection2);
        VmTransportChannel transportChannel = (VmTransportChannel)connection.getTransportChannel();
        BrokerClientImpl brokerClient = (BrokerClientImpl)transportChannel.getSendListener();
        Broker broker = brokerClient.getBrokerConnector().getBrokerContainer().getBroker();
        VmTransportChannel transportChannel2 = (VmTransportChannel)connection2.getTransportChannel();
        BrokerClientImpl brokerClient2 = (BrokerClientImpl)transportChannel2.getSendListener();
        Broker broker2 = brokerClient2.getBrokerConnector().getBrokerContainer().getBroker();
        EmbeddedBrokerTest.assertTrue((broker == broker2 ? 1 : 0) != 0);
    }

    public void testInitialContextsCreateOnlyOneBroker() throws JMSException, NamingException {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "org.activemq.jndi.ActiveMQInitialContextFactory");
        props.setProperty("java.naming.provider.url", "vm://localhost");
        InitialContext ctx = new InitialContext(props);
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)ctx.lookup("ConnectionFactory");
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        EmbeddedBrokerTest.assertNotNull((Object)connection);
        Properties props2 = new Properties();
        props2.setProperty("java.naming.factory.initial", "org.activemq.jndi.ActiveMQInitialContextFactory");
        props2.setProperty("java.naming.provider.url", "vm://localhost");
        InitialContext ctx2 = new InitialContext(props2);
        ActiveMQConnectionFactory factory2 = (ActiveMQConnectionFactory)ctx2.lookup("ConnectionFactory");
        ActiveMQConnection connection2 = (ActiveMQConnection)factory2.createConnection();
        EmbeddedBrokerTest.assertNotNull((Object)connection2);
        VmTransportChannel transportChannel = (VmTransportChannel)connection.getTransportChannel();
        BrokerClientImpl brokerClient = (BrokerClientImpl)transportChannel.getSendListener();
        Broker broker = brokerClient.getBrokerConnector().getBrokerContainer().getBroker();
        VmTransportChannel transportChannel2 = (VmTransportChannel)connection2.getTransportChannel();
        BrokerClientImpl brokerClient2 = (BrokerClientImpl)transportChannel2.getSendListener();
        Broker broker2 = brokerClient2.getBrokerConnector().getBrokerContainer().getBroker();
        EmbeddedBrokerTest.assertTrue((broker == broker2 ? 1 : 0) != 0);
    }
}

