/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnectionFactory;

public class ConsumerReceiveWithTimeoutTest
extends TestCase {
    private Connection connection;

    protected void setUp() throws Exception {
        this.connection = this.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    protected Connection createConnection() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        return factory.createConnection();
    }

    public void testConsumerReceiveBeforeMessageDispatched() throws JMSException {
        this.connection.start();
        final Session session = this.connection.createSession(false, 1);
        final Queue queue = session.createQueue("test");
        Thread t = new Thread(){

            public void run() {
                try {
                    Thread.sleep(10000L);
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.send((Message)session.createTextMessage("Hello"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(60000L);
        ConsumerReceiveWithTimeoutTest.assertNotNull((Object)msg);
        session.close();
    }
}

