/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.message.ActiveMQDestination;

public class BrokerAdminCommandsTest
extends TestCase {
    private Connection connection;

    protected void setUp() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        this.connection = factory.createConnection();
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
    }

    public void testDestroyDestination() throws JMSException {
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("testQueue");
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.setDeliveryMode(1);
        producer.send((Message)session.createTextMessage("First"));
        producer.setDeliveryMode(2);
        producer.send((Message)session.createTextMessage("Second"));
        session.close();
        ((ActiveMQConnection)this.connection).destroyDestination((ActiveMQDestination)queue);
        session = this.connection.createSession(false, 1);
        producer = session.createProducer((Destination)queue);
        producer.setDeliveryMode(1);
        producer.send((Message)session.createTextMessage("Last"));
        MessageConsumer startedConsumer = session.createConsumer((Destination)queue);
        Message m = startedConsumer.receive(1000L);
        BrokerAdminCommandsTest.assertNotNull((Object)m);
        BrokerAdminCommandsTest.assertEquals((String)"Last", (String)((TextMessage)m).getText());
    }
}

