/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.HashMap;
import java.util.Iterator;

public class MarshallingSupport {
    public static final byte NULL = 0;
    public static final byte BOOLEAN_TYPE = 1;
    public static final byte BYTE_TYPE = 2;
    public static final byte CHAR_TYPE = 3;
    public static final byte SHORT_TYPE = 4;
    public static final byte INTEGER_TYPE = 5;
    public static final byte LONG_TYPE = 6;
    public static final byte DOUBLE_TYPE = 7;
    public static final byte FLOAT_TYPE = 8;
    public static final byte STRING_TYPE = 9;
    public static final byte BYTE_ARRAY_TYPE = 10;

    public static void marshalPrimitiveMap(HashMap map, DataOutputStream out) throws IOException {
        if (map == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(map.size());
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                out.writeUTF(name);
                Object value = map.get(name);
                MarshallingSupport.marshalPrimitive(out, value);
            }
        }
    }

    public static HashMap unmarshalPrimitiveMap(DataInputStream in) throws IOException {
        int size = in.readInt();
        if (size < 0) {
            return null;
        }
        HashMap<String, Object> rc = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            rc.put(name, MarshallingSupport.unmarshalPrimitive(in));
        }
        return rc;
    }

    public static void marshalPrimitive(DataOutputStream out, Object value) throws IOException {
        if (value == null) {
            out.writeByte(0);
        } else if (value.getClass() == Boolean.class) {
            out.writeByte(1);
            out.writeBoolean((Boolean)value);
        } else if (value.getClass() == Byte.class) {
            out.writeByte(2);
            out.writeByte(((Byte)value).byteValue());
        } else if (value.getClass() == Character.class) {
            out.writeByte(3);
            out.writeChar(((Character)value).charValue());
        } else if (value.getClass() == Short.class) {
            out.writeByte(4);
            out.writeShort(((Short)value).shortValue());
        } else if (value.getClass() == Integer.class) {
            out.writeByte(5);
            out.writeInt((Integer)value);
        } else if (value.getClass() == Long.class) {
            out.writeByte(6);
            out.writeLong((Long)value);
        } else if (value.getClass() == Float.class) {
            out.writeByte(8);
            out.writeFloat(((Float)value).floatValue());
        } else if (value.getClass() == Double.class) {
            out.writeByte(7);
            out.writeDouble((Double)value);
        } else if (value.getClass() == [B.class) {
            out.writeByte(10);
            out.writeInt(((byte[])value).length);
            out.write((byte[])value);
        } else if (value.getClass() == String.class) {
            out.writeByte(9);
            out.writeUTF((String)value);
        } else {
            throw new IOException("Object is not a primitive: " + value);
        }
    }

    public static Object unmarshalPrimitive(DataInputStream in) throws IOException {
        Object value = null;
        switch (in.readByte()) {
            case 2: {
                value = new Byte(in.readByte());
                break;
            }
            case 1: {
                value = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 3: {
                value = new Character(in.readChar());
                break;
            }
            case 4: {
                value = new Short(in.readShort());
                break;
            }
            case 5: {
                value = new Integer(in.readInt());
                break;
            }
            case 6: {
                value = new Long(in.readLong());
                break;
            }
            case 8: {
                value = new Float(in.readFloat());
                break;
            }
            case 7: {
                value = new Double(in.readDouble());
                break;
            }
            case 10: {
                value = new byte[in.readInt()];
                in.readFully((byte[])value);
                break;
            }
            case 9: {
                value = in.readUTF();
            }
        }
        return value;
    }

    public static void writeUTF8(DataOutput dataOut, String text) throws IOException {
        if (text != null) {
            char c;
            int strlen = text.length();
            int utflen = 0;
            char[] charr = new char[strlen];
            int count = 0;
            text.getChars(0, strlen, charr, 0);
            for (int i = 0; i < strlen; ++i) {
                c = charr[i];
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            byte[] bytearr = new byte[utflen + 4];
            bytearr[count++] = (byte)(utflen >>> 24 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 16 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
            for (int i = 0; i < strlen; ++i) {
                c = charr[i];
                if (c >= '\u0001' && c <= '\u007f') {
                    bytearr[count++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            dataOut.write(bytearr);
        } else {
            dataOut.writeInt(-1);
        }
    }

    public static String readUTF8(DataInput dataIn) throws IOException {
        int utflen = dataIn.readInt();
        if (utflen > -1) {
            StringBuffer str = new StringBuffer(utflen);
            byte[] bytearr = new byte[utflen];
            int count = 0;
            dataIn.readFully(bytearr, 0, utflen);
            block5: while (count < utflen) {
                int c = bytearr[count] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        str.append((char)c);
                        continue block5;
                    }
                    case 12: 
                    case 13: {
                        if ((count += 2) > utflen) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                        continue block5;
                    }
                    case 14: {
                        if ((count += 3) > utflen) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = bytearr[count - 2];
                        byte char3 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                        continue block5;
                    }
                }
                throw new UTFDataFormatException();
            }
            return new String(str);
        }
        return null;
    }
}

