/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.DataOutput;
import java.io.IOException;
import javax.jms.JMSException;
import org.activemq.command.ActiveMQBytesMessage;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQTextMessage;
import org.activemq.command.ConsumerId;
import org.activemq.command.MessageAck;
import org.activemq.command.RemoveInfo;
import org.activemq.transport.stomp.AckListener;
import org.activemq.transport.stomp.FrameBuilder;
import org.activemq.transport.stomp.StompWireFormat;

public class Subscription {
    private ActiveMQDestination destination;
    private int ackMode = 1;
    private StompWireFormat format;
    private final ConsumerId consumerId;
    private final String subscriptionId;
    public static final String NO_ID = "~~ NO SUCH THING ~~%%@#!Q";
    static final int AUTO_ACK = 1;
    static final int CLIENT_ACK = 2;

    public Subscription(StompWireFormat format, ConsumerId consumerId, String subscriptionId) {
        this.format = format;
        this.consumerId = consumerId;
        this.subscriptionId = subscriptionId;
    }

    void setDestination(ActiveMQDestination actual_dest) {
        this.destination = actual_dest;
    }

    void receive(ActiveMQTextMessage msg, DataOutput out) throws IOException, JMSException {
        if (this.ackMode == 2) {
            AckListener listener = new AckListener(msg, this.consumerId, this.subscriptionId);
            this.format.addAckListener(listener);
        } else if (this.ackMode == 1) {
            MessageAck ack = new MessageAck();
            ack.setDestination(msg.getDestination());
            ack.setConsumerId(this.consumerId);
            ack.setMessageID(msg.getMessageId());
            ack.setAckType((byte)2);
            this.format.enqueueCommand(ack);
        }
        FrameBuilder builder = new FrameBuilder("MESSAGE").addHeaders(msg).setBody(msg.getText().getBytes());
        if (!this.subscriptionId.equals(NO_ID)) {
            builder.addHeader("subscription", this.subscriptionId);
        }
        out.write(builder.toFrame());
    }

    void receive(ActiveMQBytesMessage msg, DataOutput out) throws IOException, JMSException {
        if (this.ackMode == 2) {
            AckListener listener = new AckListener(msg, this.consumerId, this.subscriptionId);
            this.format.addAckListener(listener);
        } else if (this.ackMode == 1) {
            MessageAck ack = new MessageAck();
            ack.setDestination(msg.getDestination());
            ack.setConsumerId(this.consumerId);
            ack.setMessageID(msg.getMessageId());
            ack.setAckType((byte)2);
            this.format.enqueueCommand(ack);
        }
        FrameBuilder builder = new FrameBuilder("MESSAGE").addHeaders(msg).setBody(msg.getContent().getData());
        if (!this.subscriptionId.equals(NO_ID)) {
            builder.addHeader("subscription", this.subscriptionId);
        }
        out.write(builder.toFrame());
    }

    ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setAckMode(int clientAck) {
        this.ackMode = clientAck;
    }

    public RemoveInfo close() {
        RemoveInfo unsub = new RemoveInfo();
        unsub.setObjectId(this.consumerId);
        return unsub;
    }
}

