/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.List;
import java.util.Properties;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQMessage;
import org.activemq.command.MessageAck;
import org.activemq.command.TransactionId;
import org.activemq.transport.stomp.AckListener;
import org.activemq.transport.stomp.CommandEnvelope;
import org.activemq.transport.stomp.HeaderParser;
import org.activemq.transport.stomp.StompCommand;
import org.activemq.transport.stomp.StompWireFormat;

class Ack
implements StompCommand {
    private final StompWireFormat format;
    private static final HeaderParser parser = new HeaderParser();

    Ack(StompWireFormat format) {
        this.format = format;
    }

    public CommandEnvelope build(String commandLine, DataInput in) throws IOException {
        Properties headers = parser.parse(in);
        String message_id = headers.getProperty("message-id");
        if (message_id == null) {
            throw new ProtocolException("ACK received without a message-id to acknowledge!");
        }
        List listeners = this.format.getAckListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            AckListener listener = (AckListener)listeners.get(i);
            if (!listener.handle(message_id)) continue;
            listeners.remove(i);
            ActiveMQMessage msg = listener.getMessage();
            MessageAck ack = new MessageAck();
            ack.setDestination((ActiveMQDestination)msg.getJMSDestination());
            ack.setConsumerId(listener.getConsumerId());
            ack.setMessageID(msg.getMessageId());
            ack.setAckType((byte)2);
            if (headers.containsKey("transaction")) {
                TransactionId tx_id = this.format.getTransactionId(headers.getProperty("transaction"));
                if (tx_id == null) {
                    throw new ProtocolException(headers.getProperty("transaction") + " is an invalid transaction id");
                }
                ack.setTransactionId(tx_id);
            }
            while (in.readByte() != 0) {
            }
            return new CommandEnvelope(ack, headers);
        }
        while (in.readByte() != 0) {
        }
        throw new ProtocolException("Unexepected ACK received for message-id [" + message_id + "]");
    }
}

