/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.mock;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.activemq.transport.MutexTransport;
import org.activemq.transport.ResponseCorrelator;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportServer;
import org.activemq.transport.mock.MockTransport;
import org.activemq.util.IntrospectionSupport;
import org.activemq.util.URISupport;

public class MockTransportFactory
extends TransportFactory {
    public Transport doConnect(URI location) throws URISyntaxException, Exception {
        Transport transport = this.createTransport(URISupport.parseComposite(location));
        transport = new MutexTransport(transport);
        transport = new ResponseCorrelator(transport);
        return transport;
    }

    public Transport doCompositeConnect(URI location) throws URISyntaxException, Exception {
        return this.createTransport(URISupport.parseComposite(location));
    }

    public Transport createTransport(URISupport.CompositeData compositData) throws Exception {
        MockTransport transport = new MockTransport(TransportFactory.compositeConnect(compositData.getComponents()[0]));
        IntrospectionSupport.setProperties(transport, compositData.getParameters());
        return transport;
    }

    public TransportServer doBind(String brokerId, URI location) throws IOException {
        throw new IOException("This protocol does not support being bound.");
    }
}

