/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.mock;

import java.io.IOException;
import org.activemq.command.Command;
import org.activemq.command.Response;
import org.activemq.transport.FutureResponse;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFilter;
import org.activemq.transport.TransportListener;

public class MockTransport
implements Transport,
TransportListener {
    protected Transport next;
    protected TransportListener commandListener;

    public MockTransport(Transport next) {
        this.next = next;
    }

    public synchronized void setTransportListener(TransportListener channelListener) {
        this.commandListener = channelListener;
        if (channelListener == null) {
            this.next.setTransportListener(null);
        } else {
            this.next.setTransportListener(this);
        }
    }

    public void start() throws Exception {
        if (this.next == null) {
            throw new IOException("The next channel has not been set.");
        }
        if (this.commandListener == null) {
            throw new IOException("The command listener has not been set.");
        }
        this.next.start();
    }

    public void stop() throws Exception {
        this.next.stop();
    }

    public synchronized void onCommand(Command command) {
        this.commandListener.onCommand(command);
    }

    public synchronized Transport getNext() {
        return this.next;
    }

    public synchronized TransportListener getCommandListener() {
        return this.commandListener;
    }

    public synchronized String toString() {
        return this.next.toString();
    }

    public synchronized void oneway(Command command) throws IOException {
        this.next.oneway(command);
    }

    public synchronized FutureResponse asyncRequest(Command command) throws IOException {
        return this.next.asyncRequest(command);
    }

    public synchronized Response request(Command command) throws IOException {
        return this.next.request(command);
    }

    public synchronized void onException(IOException error) {
        this.commandListener.onException(error);
    }

    public synchronized Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.next.narrow(target);
    }

    public synchronized void setNext(Transport next) {
        this.next = next;
    }

    public synchronized void install(TransportFilter filter) {
        filter.setTransportListener(this);
        this.getNext().setTransportListener(filter);
        this.setNext(filter);
    }
}

