/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.activeio.command.WireFormat;
import org.activemq.command.Command;
import org.activemq.command.WireFormatInfo;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFilter;

public class WireFormatNegotiator
extends TransportFilter {
    private final WireFormat wireFormat;
    private final int minimumVersion;
    private boolean firstStart = true;
    private CountDownLatch readyCountDownLatch = new CountDownLatch(1);

    public WireFormatNegotiator(Transport next, WireFormat wireFormat, int minimumVersion) {
        super(next);
        this.wireFormat = wireFormat;
        this.minimumVersion = minimumVersion;
    }

    public void start() throws Exception {
        super.start();
        if (this.firstStart) {
            WireFormatInfo info = this.createWireFormatInfo();
            this.next.oneway(info);
        }
    }

    public void oneway(Command command) throws IOException {
        try {
            this.readyCountDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        super.oneway(command);
    }

    protected WireFormatInfo createWireFormatInfo() {
        WireFormatInfo info = new WireFormatInfo();
        info.setVersion(this.wireFormat.getVersion());
        if (this.wireFormat instanceof OpenWireFormat) {
            info.setStackTraceEnabled(((OpenWireFormat)this.wireFormat).isStackTraceEnabled());
            info.setTcpNoDelayEnabled(((OpenWireFormat)this.wireFormat).isTcpNoDelayEnabled());
            info.setCacheEnabled(((OpenWireFormat)this.wireFormat).isCacheEnabled());
        }
        return info;
    }

    public void onCommand(Command command) {
        if (command.isWireFormatInfo()) {
            WireFormatInfo info = (WireFormatInfo)command;
            if (!info.isValid()) {
                this.commandListener.onException(new IOException("Remote wire format magic is invalid"));
            } else if (info.getVersion() < this.minimumVersion) {
                this.commandListener.onException(new IOException("Remote wire format (" + info.getVersion() + ") is lower the minimum version required (" + this.minimumVersion + ")"));
            } else if (info.getVersion() != this.wireFormat.getVersion()) {
                this.wireFormat.setVersion(info.getVersion());
            }
            if (this.wireFormat instanceof OpenWireFormat) {
                if (!info.isStackTraceEnabled()) {
                    ((OpenWireFormat)this.wireFormat).setStackTraceEnabled(false);
                }
                if (info.isTcpNoDelayEnabled()) {
                    ((OpenWireFormat)this.wireFormat).setTcpNoDelayEnabled(true);
                }
                if (!info.isCacheEnabled()) {
                    ((OpenWireFormat)this.wireFormat).setCacheEnabled(false);
                }
            }
            this.readyCountDownLatch.countDown();
        }
        this.commandListener.onCommand(command);
    }
}

