/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.thread;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import org.activemq.thread.Task;
import org.activemq.thread.TaskRunner;

class SimpleTaskRunner
implements TaskRunner {
    private final int maxIterationsPerRun;
    private final Executor executor;
    private final Task task;
    private final Runnable runable;
    private boolean queued;
    private boolean shutdown;
    private boolean iterating;
    private Thread runningThread;

    public SimpleTaskRunner(Executor executor, Task task, int maxIterationsPerRun) {
        this.executor = executor;
        this.maxIterationsPerRun = maxIterationsPerRun;
        this.task = task;
        this.runable = new Runnable(){

            public void run() {
                SimpleTaskRunner.this.runningThread = Thread.currentThread();
                SimpleTaskRunner.this.runTask();
                SimpleTaskRunner.this.runningThread = null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() throws InterruptedException {
        Runnable runnable = this.runable;
        synchronized (runnable) {
            if (this.queued || this.shutdown) {
                return;
            }
            this.queued = true;
            if (!this.iterating) {
                this.executor.execute(this.runable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        Runnable runnable = this.runable;
        synchronized (runnable) {
            this.shutdown = true;
            if (this.runningThread != Thread.currentThread()) {
                while (this.iterating) {
                    this.runable.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask() {
        Runnable runnable = this.runable;
        synchronized (runnable) {
            this.queued = false;
            if (this.shutdown) {
                this.iterating = false;
                this.runable.notifyAll();
                return;
            }
            this.iterating = true;
        }
        boolean done = false;
        for (int i = 0; i < this.maxIterationsPerRun; ++i) {
            if (this.task.iterate()) continue;
            done = true;
            break;
        }
        Runnable runnable2 = this.runable;
        synchronized (runnable2) {
            this.iterating = false;
            if (this.shutdown) {
                this.queued = false;
                this.runable.notifyAll();
                return;
            }
            if (!done) {
                this.queued = true;
            }
            if (this.queued) {
                this.executor.execute(this.runable);
            }
        }
    }
}

