/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.journal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.activeio.journal.RecordLocation;
import org.activeio.journal.active.Location;
import org.activemq.broker.ConnectionContext;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.JournalQueueAck;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.MessageId;
import org.activemq.store.MessageRecoveryListener;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.journal.QuickJournalMessageData;
import org.activemq.store.journal.QuickJournalPersistenceAdapter;
import org.activemq.store.journal.QuickJournalTransactionStore;
import org.activemq.transaction.Synchronization;
import org.activemq.util.Callback;
import org.activemq.util.TransactionTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuickJournalMessageStore
implements MessageStore {
    private static final Log log = LogFactory.getLog((Class)QuickJournalMessageStore.class);
    protected final QuickJournalPersistenceAdapter peristenceAdapter;
    protected final QuickJournalTransactionStore transactionStore;
    protected final MessageStore longTermStore;
    protected final ActiveMQDestination destination;
    protected final TransactionTemplate transactionTemplate;
    private LinkedHashMap messages = new LinkedHashMap();
    private ArrayList messageAcks = new ArrayList();
    private LinkedHashMap cpAddedMessageIds;
    protected RecordLocation lastLocation;
    protected HashSet inFlightTxLocations = new HashSet();

    public QuickJournalMessageStore(QuickJournalPersistenceAdapter adapter, MessageStore checkpointStore, ActiveMQDestination destination) {
        this.peristenceAdapter = adapter;
        this.transactionStore = adapter.getTransactionStore();
        this.longTermStore = checkpointStore;
        this.destination = destination;
        this.transactionTemplate = new TransactionTemplate(adapter, new ConnectionContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(ConnectionContext context, final Message message) throws IOException {
        final MessageId id = message.getMessageId();
        final boolean debug = log.isDebugEnabled();
        final RecordLocation location = this.peristenceAdapter.writeCommand(message, message.isResponseRequired());
        final QuickJournalMessageData md = new QuickJournalMessageData(message, location);
        if (!context.isInTransaction()) {
            if (debug) {
                log.debug((Object)("Journalled message add for: " + id + ", at: " + location));
            }
            this.addMessage(md, location);
        } else {
            message.incrementReferenceCount();
            if (debug) {
                log.debug((Object)("Journalled transacted message add for: " + id + ", at: " + location));
            }
            QuickJournalMessageStore quickJournalMessageStore = this;
            synchronized (quickJournalMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.addMessage(this, message, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() {
                    if (debug) {
                        log.debug((Object)("Transacted message add commit for: " + id + ", at: " + location));
                    }
                    message.decrementReferenceCount();
                    QuickJournalMessageStore quickJournalMessageStore = QuickJournalMessageStore.this;
                    synchronized (quickJournalMessageStore) {
                        QuickJournalMessageStore.this.inFlightTxLocations.remove(location);
                        QuickJournalMessageStore.this.addMessage(md, location);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRollback() {
                    if (debug) {
                        log.debug((Object)("Transacted message add rollback for: " + id + ", at: " + location));
                    }
                    message.decrementReferenceCount();
                    QuickJournalMessageStore quickJournalMessageStore = QuickJournalMessageStore.this;
                    synchronized (quickJournalMessageStore) {
                        QuickJournalMessageStore.this.inFlightTxLocations.remove(location);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(QuickJournalMessageData message, RecordLocation location) {
        QuickJournalMessageStore quickJournalMessageStore = this;
        synchronized (quickJournalMessageStore) {
            this.lastLocation = location;
            MessageId id = message.getMessageId();
            this.messages.put(id, message);
        }
    }

    protected static String toString(RecordLocation location) {
        Location l = (Location)location;
        return l.getLogFileId() + ":" + l.getLogFileOffset();
    }

    protected static RecordLocation toRecordLocation(String t) {
        String[] strings = t.split(":");
        if (strings.length != 2) {
            throw new IllegalArgumentException("Invalid location: " + t);
        }
        return new Location(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]));
    }

    public void replayAddMessage(ConnectionContext context, Message message, RecordLocation location) {
        try {
            String t = this.longTermStore.getMessageReference(message.getMessageId());
            if (t == null) {
                this.longTermStore.addMessageReference(context, message.getMessageId(), message.getExpiration(), QuickJournalMessageStore.toString(location));
            }
        }
        catch (Throwable e) {
            log.warn((Object)("Could not replay add for message '" + message.getMessageId() + "'.  Message may have already been added. reason: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(ConnectionContext context, final MessageAck ack) throws IOException {
        final boolean debug = log.isDebugEnabled();
        JournalQueueAck remove = new JournalQueueAck();
        remove.setDestination(this.destination);
        remove.setMessageAck(ack);
        final RecordLocation location = this.peristenceAdapter.writeCommand(remove, ack.isResponseRequired());
        if (!context.isInTransaction()) {
            if (debug) {
                log.debug((Object)("Journalled message remove for: " + ack.getLastMessageId() + ", at: " + location));
            }
            this.removeMessage(ack, location);
        } else {
            if (debug) {
                log.debug((Object)("Journalled transacted message remove for: " + ack.getLastMessageId() + ", at: " + location));
            }
            QuickJournalMessageStore quickJournalMessageStore = this;
            synchronized (quickJournalMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.removeMessage(this, ack, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() {
                    if (debug) {
                        log.debug((Object)("Transacted message remove commit for: " + ack.getLastMessageId() + ", at: " + location));
                    }
                    QuickJournalMessageStore quickJournalMessageStore = QuickJournalMessageStore.this;
                    synchronized (quickJournalMessageStore) {
                        QuickJournalMessageStore.this.inFlightTxLocations.remove(location);
                        QuickJournalMessageStore.this.removeMessage(ack, location);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRollback() {
                    if (debug) {
                        log.debug((Object)("Transacted message remove rollback for: " + ack.getLastMessageId() + ", at: " + location));
                    }
                    QuickJournalMessageStore quickJournalMessageStore = QuickJournalMessageStore.this;
                    synchronized (quickJournalMessageStore) {
                        QuickJournalMessageStore.this.inFlightTxLocations.remove(location);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessage(MessageAck ack, RecordLocation location) {
        QuickJournalMessageStore quickJournalMessageStore = this;
        synchronized (quickJournalMessageStore) {
            this.lastLocation = location;
            MessageId id = ack.getLastMessageId();
            if (this.messages.remove(id) == null) {
                this.messageAcks.add(ack);
            }
        }
    }

    public void replayRemoveMessage(ConnectionContext context, MessageAck messageAck) {
        try {
            String t = this.longTermStore.getMessageReference(messageAck.getLastMessageId());
            if (t != null) {
                this.longTermStore.removeMessage(context, messageAck);
            }
        }
        catch (Throwable e) {
            log.warn((Object)("Could not replay acknowledge for message '" + messageAck.getLastMessageId() + "'.  Message may have already been acknowledged. reason: " + e));
        }
    }

    public RecordLocation checkpoint() throws IOException {
        return this.checkpoint(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint(final Callback postCheckpointTest) throws IOException {
        ArrayList cpActiveJournalLocations;
        ArrayList cpRemovedMessageLocations;
        final int maxCheckpointMessageAddSize = this.peristenceAdapter.getMaxCheckpointMessageAddSize();
        QuickJournalMessageStore quickJournalMessageStore = this;
        synchronized (quickJournalMessageStore) {
            this.cpAddedMessageIds = this.messages;
            cpRemovedMessageLocations = this.messageAcks;
            cpActiveJournalLocations = new ArrayList(this.inFlightTxLocations);
            this.messages = new LinkedHashMap();
            this.messageAcks = new ArrayList();
        }
        this.transactionTemplate.run(new Callback(){

            public void execute() throws Throwable {
                int size = 0;
                PersistenceAdapter persitanceAdapter = QuickJournalMessageStore.this.transactionTemplate.getPersistenceAdapter();
                ConnectionContext context = QuickJournalMessageStore.this.transactionTemplate.getContext();
                Iterator<Object> iterator = QuickJournalMessageStore.this.cpAddedMessageIds.values().iterator();
                while (iterator.hasNext()) {
                    QuickJournalMessageData message = (QuickJournalMessageData)iterator.next();
                    try {
                        String l = QuickJournalMessageStore.toString(message.getLocation());
                        QuickJournalMessageStore.this.longTermStore.addMessageReference(context, message.getMessageId(), message.getExpiration(), l);
                    }
                    catch (Throwable e) {
                        log.warn((Object)("Message could not be added to long term store: " + e.getMessage()), e);
                    }
                    iterator.remove();
                    if (++size < maxCheckpointMessageAddSize) continue;
                    persitanceAdapter.commitTransaction(context);
                    persitanceAdapter.beginTransaction(context);
                    size = 0;
                }
                persitanceAdapter.commitTransaction(context);
                persitanceAdapter.beginTransaction(context);
                iterator = cpRemovedMessageLocations.iterator();
                while (iterator.hasNext()) {
                    try {
                        MessageAck ack = (MessageAck)iterator.next();
                        QuickJournalMessageStore.this.longTermStore.removeMessage(QuickJournalMessageStore.this.transactionTemplate.getContext(), ack);
                    }
                    catch (Throwable e) {
                        log.debug((Object)("Message could not be removed from long term store: " + e.getMessage()), e);
                    }
                }
                if (postCheckpointTest != null) {
                    postCheckpointTest.execute();
                }
            }
        });
        quickJournalMessageStore = this;
        synchronized (quickJournalMessageStore) {
            this.cpAddedMessageIds = null;
        }
        if (cpActiveJournalLocations.size() > 0) {
            Collections.sort(cpActiveJournalLocations);
            return (RecordLocation)cpActiveJournalLocations.get(0);
        }
        return this.lastLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(MessageId identity) throws IOException {
        RecordLocation loc = null;
        QuickJournalMessageStore quickJournalMessageStore = this;
        synchronized (quickJournalMessageStore) {
            QuickJournalMessageData answer = null;
            answer = (QuickJournalMessageData)this.messages.get(identity);
            if (answer == null && this.cpAddedMessageIds != null) {
                answer = (QuickJournalMessageData)this.cpAddedMessageIds.get(identity);
            }
            if (answer != null) {
                loc = answer.getLocation();
            } else {
                String t = this.longTermStore.getMessageReference(identity);
                if (t != null) {
                    loc = QuickJournalMessageStore.toRecordLocation(t);
                }
            }
        }
        if (loc == null) {
            return null;
        }
        return (Message)this.peristenceAdapter.readCommand(loc);
    }

    public void recover(final MessageRecoveryListener listener) throws Throwable {
        this.peristenceAdapter.checkpoint(true, true);
        this.longTermStore.recover(new MessageRecoveryListener(){

            public void recoverMessage(Message message) throws Throwable {
                throw new IOException("Should not get called.");
            }

            public void recoverMessageReference(String messageReference) throws Throwable {
                RecordLocation loc = QuickJournalMessageStore.toRecordLocation(messageReference);
                Message message = (Message)QuickJournalMessageStore.this.peristenceAdapter.readCommand(loc);
                listener.recoverMessage(message);
            }
        });
    }

    public void start() throws IOException {
        this.longTermStore.start();
    }

    public void stop(long timeout) throws IOException {
        this.longTermStore.stop(timeout);
    }

    public MessageStore getLongTermMessageStore() {
        return this.longTermStore;
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.peristenceAdapter.checkpoint(true, true);
        this.longTermStore.removeAllMessages(context);
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        throw new IOException("The journal does not support message references.");
    }

    public String getMessageReference(MessageId identity) throws IOException {
        throw new IOException("The journal does not support message references.");
    }
}

