/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc.adapter;

import org.activemq.store.jdbc.StatementProvider;

public class DefaultStatementProvider
implements StatementProvider {
    protected String tablePrefix = "";
    protected String messageTableName = "ACTIVEMQ_MSGS";
    protected String durableSubAcksTableName = "ACTIVEMQ_ACKS";
    protected String binaryDataType = "BLOB";
    protected String containerNameDataType = "VARCHAR(250)";
    protected String xidDataType = "VARCHAR(250)";
    protected String msgIdDataType = "VARCHAR(250)";
    protected String sequenceDataType = "INTEGER";
    protected String longDataType = "BIGINT";
    protected String stringIdDataType = "VARCHAR(250)";
    protected boolean useExternalMessageReferences = false;

    public String[] getCreateSchemaStatments() {
        return new String[]{"CREATE TABLE " + this.tablePrefix + this.messageTableName + "(" + "ID " + this.sequenceDataType + " NOT NULL" + ", CONTAINER " + this.containerNameDataType + ", MSGID_PROD " + this.msgIdDataType + ", MSGID_SEQ " + this.sequenceDataType + ", EXPIRATION " + this.longDataType + ", MSG " + (this.useExternalMessageReferences ? this.stringIdDataType : this.binaryDataType) + ", PRIMARY KEY ( ID ) )", "CREATE INDEX " + this.tablePrefix + this.messageTableName + "_MIDX ON " + this.tablePrefix + this.messageTableName + " (MSGID_PROD,MSGID_SEQ)", "CREATE INDEX " + this.tablePrefix + this.messageTableName + "_CIDX ON " + this.tablePrefix + this.messageTableName + " (CONTAINER)", "CREATE TABLE " + this.tablePrefix + this.durableSubAcksTableName + "(" + "CONTAINER " + this.containerNameDataType + " NOT NULL" + ", CLIENT_ID " + this.stringIdDataType + " NOT NULL" + ", SUB_NAME " + this.stringIdDataType + " NOT NULL" + ", SELECTOR " + this.stringIdDataType + ", LAST_ACKED_ID " + this.sequenceDataType + ", PRIMARY KEY ( CONTAINER, CLIENT_ID, SUB_NAME))"};
    }

    public String[] getDropSchemaStatments() {
        return new String[]{"DROP TABLE " + this.tablePrefix + this.durableSubAcksTableName + "", "DROP TABLE " + this.tablePrefix + this.messageTableName + ""};
    }

    public String getAddMessageStatment() {
        return "INSERT INTO " + this.tablePrefix + this.messageTableName + "(ID, MSGID_PROD, MSGID_SEQ, CONTAINER, EXPIRATION, MSG) VALUES (?, ?, ?, ?, ?, ?)";
    }

    public String getUpdateMessageStatment() {
        return "UPDATE " + this.tablePrefix + this.messageTableName + " SET MSG=? WHERE ID=?";
    }

    public String getRemoveMessageStatment() {
        return "DELETE FROM " + this.tablePrefix + this.messageTableName + " WHERE ID=?";
    }

    public String getFindMessageSequenceIdStatment() {
        return "SELECT ID FROM " + this.tablePrefix + this.messageTableName + " WHERE MSGID_PROD=? AND MSGID_SEQ=?";
    }

    public String getFindMessageStatment() {
        return "SELECT MSG FROM " + this.tablePrefix + this.messageTableName + " WHERE ID=?";
    }

    public String getFindAllMessagesStatment() {
        return "SELECT ID, MSG FROM " + this.tablePrefix + this.messageTableName + " WHERE CONTAINER=? ORDER BY ID";
    }

    public String getFindLastSequenceIdInMsgs() {
        return "SELECT MAX(ID) FROM " + this.tablePrefix + this.messageTableName;
    }

    public String getFindLastSequenceIdInAcks() {
        return "SELECT MAX(LAST_ACKED_ID) FROM " + this.tablePrefix + this.durableSubAcksTableName;
    }

    public String getCreateDurableSubStatment() {
        return "INSERT INTO " + this.tablePrefix + this.durableSubAcksTableName + "(CONTAINER, CLIENT_ID, SUB_NAME, SELECTOR, LAST_ACKED_ID) " + "VALUES (?, ?, ?, ?, ?)";
    }

    public String getFindDurableSubStatment() {
        return "SELECT SELECTOR, SUB_NAME FROM " + this.tablePrefix + this.durableSubAcksTableName + " WHERE CONTAINER=? AND CLIENT_ID=? AND SUB_NAME=?";
    }

    public String getUpdateLastAckOfDurableSub() {
        return "UPDATE " + this.tablePrefix + this.durableSubAcksTableName + " SET LAST_ACKED_ID=?" + " WHERE CONTAINER=? AND CLIENT_ID=? AND SUB_NAME=?";
    }

    public String getDeleteSubscriptionStatment() {
        return "DELETE FROM " + this.tablePrefix + this.durableSubAcksTableName + " WHERE CONTAINER=? AND CLIENT_ID=? AND SUB_NAME=?";
    }

    public String getFindAllDurableSubMessagesStatment() {
        return "SELECT M.ID, M.MSG FROM " + this.tablePrefix + this.messageTableName + " M, " + this.tablePrefix + this.durableSubAcksTableName + " D " + " WHERE D.CONTAINER=? AND D.CLIENT_ID=? AND D.SUB_NAME=?" + " AND M.CONTAINER=D.CONTAINER AND M.ID > D.LAST_ACKED_ID" + " ORDER BY M.ID";
    }

    public String getFindAllDestinationsStatment() {
        return "SELECT DISTINCT CONTAINER FROM " + this.tablePrefix + this.messageTableName;
    }

    public String getRemoveAllMessagesStatment() {
        return "DELETE FROM " + this.tablePrefix + this.messageTableName + " WHERE CONTAINER=?";
    }

    public String getRemoveAllSubscriptionsStatment() {
        return "DELETE FROM " + this.tablePrefix + this.durableSubAcksTableName + " WHERE CONTAINER=?";
    }

    public String getDeleteOldMessagesStatment() {
        return "DELETE FROM " + this.tablePrefix + this.messageTableName + " WHERE ( EXPIRATION<>0 AND EXPIRATION<?) OR ID <= " + "( SELECT min(" + this.tablePrefix + this.durableSubAcksTableName + ".LAST_ACKED_ID) " + "FROM " + this.tablePrefix + this.durableSubAcksTableName + " WHERE " + this.tablePrefix + this.durableSubAcksTableName + ".CONTAINER=" + this.tablePrefix + this.messageTableName + ".CONTAINER)";
    }

    public String getContainerNameDataType() {
        return this.containerNameDataType;
    }

    public void setContainerNameDataType(String containerNameDataType) {
        this.containerNameDataType = containerNameDataType;
    }

    public String getBinaryDataType() {
        return this.binaryDataType;
    }

    public void setBinaryDataType(String messageDataType) {
        this.binaryDataType = messageDataType;
    }

    public String getMessageTableName() {
        return this.messageTableName;
    }

    public void setMessageTableName(String messageTableName) {
        this.messageTableName = messageTableName;
    }

    public String getMsgIdDataType() {
        return this.msgIdDataType;
    }

    public void setMsgIdDataType(String msgIdDataType) {
        this.msgIdDataType = msgIdDataType;
    }

    public String getSequenceDataType() {
        return this.sequenceDataType;
    }

    public void setSequenceDataType(String sequenceDataType) {
        this.sequenceDataType = sequenceDataType;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getXidDataType() {
        return this.xidDataType;
    }

    public void setXidDataType(String xidDataType) {
        this.xidDataType = xidDataType;
    }

    public String getDurableSubAcksTableName() {
        return this.durableSubAcksTableName;
    }

    public void setDurableSubAcksTableName(String durableSubAcksTableName) {
        this.durableSubAcksTableName = durableSubAcksTableName;
    }

    public String getLongDataType() {
        return this.longDataType;
    }

    public void setLongDataType(String longDataType) {
        this.longDataType = longDataType;
    }

    public String getStringIdDataType() {
        return this.stringIdDataType;
    }

    public void setStringIdDataType(String stringIdDataType) {
        this.stringIdDataType = stringIdDataType;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.useExternalMessageReferences = useExternalMessageReferences;
    }

    public boolean isUseExternalMessageReferences() {
        return this.useExternalMessageReferences;
    }
}

