/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.pool;

import javax.jms.JMSException;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQSession;
import org.activemq.AlreadyClosedException;
import org.activemq.pool.PooledSession;
import org.activemq.pool.SessionKey;
import org.activemq.util.JMSExceptionSupport;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class SessionPool
implements PoolableObjectFactory {
    private ActiveMQConnection connection;
    private SessionKey key;
    private ObjectPool sessionPool;

    public SessionPool(ActiveMQConnection connection, SessionKey key) {
        this(connection, key, (ObjectPool)new GenericObjectPool());
    }

    public SessionPool(ActiveMQConnection connection, SessionKey key, ObjectPool sessionPool) {
        this.connection = connection;
        this.key = key;
        this.sessionPool = sessionPool;
        sessionPool.setFactory((PoolableObjectFactory)this);
    }

    public void close() throws Exception {
        this.sessionPool.close();
    }

    public PooledSession borrowSession() throws JMSException {
        try {
            Object object = this.sessionPool.borrowObject();
            return (PooledSession)object;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public Object makeObject() throws Exception {
        return new PooledSession(this.createSession(), this.sessionPool);
    }

    public void destroyObject(Object o) throws Exception {
        PooledSession session = (PooledSession)o;
        session.getSession().close();
    }

    public boolean validateObject(Object o) {
        return true;
    }

    public void activateObject(Object o) throws Exception {
    }

    public void passivateObject(Object o) throws Exception {
    }

    protected ActiveMQConnection getConnection() throws JMSException {
        if (this.connection == null) {
            throw new AlreadyClosedException();
        }
        return this.connection;
    }

    protected ActiveMQSession createSession() throws JMSException {
        return (ActiveMQSession)this.getConnection().createSession(this.key.isTransacted(), this.key.getAckMode());
    }
}

