/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.Service;
import org.activemq.pool.ConnectionKey;
import org.activemq.pool.PooledConnection;
import org.activemq.util.IOExceptionSupport;
import org.activemq.util.ServiceStopper;

public class PooledConnectionFactory
implements ConnectionFactory,
Service {
    private ActiveMQConnectionFactory connectionFactory;
    private Map cache = new HashMap();

    public PooledConnectionFactory() {
        this(new ActiveMQConnectionFactory());
    }

    public PooledConnectionFactory(String brokerURL) {
        this(new ActiveMQConnectionFactory(brokerURL));
    }

    public PooledConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        ConnectionKey key = new ConnectionKey(userName, password);
        PooledConnection connection = (PooledConnection)this.cache.get(key);
        if (connection == null) {
            ActiveMQConnection delegate = this.createConnection(key);
            connection = new PooledConnection(delegate);
            this.cache.put(key, connection);
        }
        return connection.newInstance();
    }

    protected ActiveMQConnection createConnection(ConnectionKey key) throws JMSException {
        if (key.getUserName() == null && key.getPassword() == null) {
            return (ActiveMQConnection)this.connectionFactory.createConnection();
        }
        return (ActiveMQConnection)this.connectionFactory.createConnection(key.getUserName(), key.getPassword());
    }

    public void start() {
        try {
            this.createConnection();
        }
        catch (JMSException e) {
            IOExceptionSupport.create((Exception)((Object)e));
        }
    }

    public void stop() throws Exception {
        ServiceStopper stopper = new ServiceStopper();
        Iterator iter = this.cache.values().iterator();
        while (iter.hasNext()) {
            PooledConnection connection = (PooledConnection)iter.next();
            try {
                connection.getConnection().close();
                connection.close();
            }
            catch (JMSException e) {
                stopper.onException(this, e);
            }
        }
        stopper.throwFirstException();
    }
}

