/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.DataStructure;
import org.activemq.command.XATransactionId;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.TransactionIdMarshaller;

public class XATransactionIdMarshaller
extends TransactionIdMarshaller {
    public byte getDataStructureType() {
        return 112;
    }

    public DataStructure createObject() {
        return new XATransactionId();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        byte[] data;
        int size;
        super.unmarshal(wireFormat, o, dataIn, bs);
        XATransactionId info = (XATransactionId)o;
        info.setFormatId(dataIn.readInt());
        if (bs.readBoolean()) {
            size = dataIn.readInt();
            data = new byte[size];
            dataIn.readFully(data);
            info.setGlobalTransactionId(data);
        } else {
            info.setGlobalTransactionId(null);
        }
        if (bs.readBoolean()) {
            size = dataIn.readInt();
            data = new byte[size];
            dataIn.readFully(data);
            info.setBranchQualifier(data);
        } else {
            info.setBranchQualifier(null);
        }
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        XATransactionId info = (XATransactionId)o;
        int rc = super.marshal1(wireFormat, o, bs);
        bs.writeBoolean(info.getGlobalTransactionId() != null);
        rc += info.getGlobalTransactionId() == null ? 0 : info.getGlobalTransactionId().length + 4;
        bs.writeBoolean(info.getBranchQualifier() != null);
        return (rc += info.getBranchQualifier() == null ? 0 : info.getBranchQualifier().length + 4) + 4;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        XATransactionId info = (XATransactionId)o;
        dataOut.writeInt(info.getFormatId());
        if (bs.readBoolean()) {
            dataOut.writeInt(info.getGlobalTransactionId().length);
            dataOut.write(info.getGlobalTransactionId());
        }
        if (bs.readBoolean()) {
            dataOut.writeInt(info.getBranchQualifier().length);
            dataOut.write(info.getBranchQualifier());
        }
    }
}

