/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.DataStructure;
import org.activemq.command.WireFormatInfo;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public class WireFormatInfoMarshaller
extends DataStreamMarshaller {
    public byte getDataStructureType() {
        return 1;
    }

    public DataStructure createObject() {
        return new WireFormatInfo();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        WireFormatInfo info = (WireFormatInfo)o;
        byte[] data = new byte[8];
        dataIn.readFully(data);
        info.setMagic(data);
        info.setVersion(dataIn.readInt());
        info.setOptions(dataIn.readInt());
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        WireFormatInfo info = (WireFormatInfo)o;
        int rc = super.marshal1(wireFormat, o, bs);
        return rc + 16;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        WireFormatInfo info = (WireFormatInfo)o;
        dataOut.write(info.getMagic(), 0, 8);
        dataOut.writeInt(info.getVersion());
        dataOut.writeInt(info.getOptions());
    }
}

