/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.DataArrayResponse;
import org.activemq.command.DataStructure;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.ResponseMarshaller;

public class DataArrayResponseMarshaller
extends ResponseMarshaller {
    public byte getDataStructureType() {
        return 33;
    }

    public DataStructure createObject() {
        return new DataArrayResponse();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        DataArrayResponse info = (DataArrayResponse)o;
        if (bs.readBoolean()) {
            int size = dataIn.readShort();
            DataStructure[] value = new DataStructure[size];
            for (int i = 0; i < size; ++i) {
                value[i] = this.unmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setData(value);
        } else {
            info.setData(null);
        }
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        DataArrayResponse info = (DataArrayResponse)o;
        int rc = super.marshal1(wireFormat, o, bs);
        return (rc += this.marshalObjectArray(wireFormat, info.getData(), bs)) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        DataArrayResponse info = (DataArrayResponse)o;
        this.marshalObjectArray(wireFormat, info.getData(), dataOut, bs);
    }
}

