/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.BrokerId;
import org.activemq.command.ConsumerId;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.DataStructure;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.BaseCommandMarshaller;

public class ConsumerInfoMarshaller
extends BaseCommandMarshaller {
    public byte getDataStructureType() {
        return 5;
    }

    public DataStructure createObject() {
        return new ConsumerInfo();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        ConsumerInfo info = (ConsumerInfo)o;
        info.setConsumerId((ConsumerId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setBrowser(bs.readBoolean());
        info.setDestination((ActiveMQDestination)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setPrefetchSize(dataIn.readInt());
        info.setDispatchAsync(bs.readBoolean());
        info.setSelector(this.readString(dataIn, bs));
        info.setSubcriptionName(this.readString(dataIn, bs));
        info.setNoLocal(bs.readBoolean());
        info.setExclusive(bs.readBoolean());
        info.setRetroactive(bs.readBoolean());
        info.setPriority(dataIn.readByte());
        if (bs.readBoolean()) {
            int size = dataIn.readShort();
            BrokerId[] value = new BrokerId[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (BrokerId)this.unmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setBrokerPath(value);
        } else {
            info.setBrokerPath(null);
        }
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ConsumerInfo info = (ConsumerInfo)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1CachedObject(wireFormat, info.getConsumerId(), bs);
        bs.writeBoolean(info.isBrowser());
        rc += this.marshal1CachedObject(wireFormat, info.getDestination(), bs);
        bs.writeBoolean(info.isDispatchAsync());
        rc += this.writeString(info.getSelector(), bs);
        rc += this.writeString(info.getSubcriptionName(), bs);
        bs.writeBoolean(info.isNoLocal());
        bs.writeBoolean(info.isExclusive());
        bs.writeBoolean(info.isRetroactive());
        return (rc += this.marshalObjectArray(wireFormat, info.getBrokerPath(), bs)) + 5;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        ConsumerInfo info = (ConsumerInfo)o;
        this.marshal2CachedObject(wireFormat, info.getConsumerId(), dataOut, bs);
        bs.readBoolean();
        this.marshal2CachedObject(wireFormat, info.getDestination(), dataOut, bs);
        dataOut.writeInt(info.getPrefetchSize());
        bs.readBoolean();
        this.writeString(info.getSelector(), dataOut, bs);
        this.writeString(info.getSubcriptionName(), dataOut, bs);
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        dataOut.writeByte(info.getPriority());
        this.marshalObjectArray(wireFormat, info.getBrokerPath(), dataOut, bs);
    }
}

