/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.ConsumerId;
import org.activemq.command.DataStructure;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public class ConsumerIdMarshaller
extends DataStreamMarshaller {
    public byte getDataStructureType() {
        return 122;
    }

    public DataStructure createObject() {
        return new ConsumerId();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        ConsumerId info = (ConsumerId)o;
        info.setConnectionId(this.readString(dataIn, bs));
        info.setSessionId(this.unmarshalLong(wireFormat, dataIn, bs));
        info.setConsumerId(this.unmarshalLong(wireFormat, dataIn, bs));
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ConsumerId info = (ConsumerId)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.writeString(info.getConnectionId(), bs);
        rc += this.marshal1Long(wireFormat, info.getSessionId(), bs);
        return (rc += this.marshal1Long(wireFormat, info.getConsumerId(), bs)) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        ConsumerId info = (ConsumerId)o;
        this.writeString(info.getConnectionId(), dataOut, bs);
        this.marshal2Long(wireFormat, info.getSessionId(), dataOut, bs);
        this.marshal2Long(wireFormat, info.getConsumerId(), dataOut, bs);
    }
}

