/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.network.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.activemq.network.jms.DestinationBridge;
import org.activemq.network.jms.JmsTopicConnector;

class TopicBridge
extends DestinationBridge {
    protected Topic consumerTopic;
    protected Topic producerTopic;
    protected TopicSession consumerSession;
    protected TopicSession producerSession;
    protected String consumerName;
    protected String selector;
    protected TopicPublisher producer;
    protected TopicConnection consumerConnection;
    protected TopicConnection producerConnection;
    protected JmsTopicConnector jmsTopicConnector;

    TopicBridge() {
    }

    public void stop() throws Exception {
        super.stop();
        if (this.consumerSession != null) {
            this.consumerSession.close();
        }
        if (this.producerSession != null) {
            this.producerSession.close();
        }
    }

    protected void setJmsTopicConnector(JmsTopicConnector connector) {
        this.jmsTopicConnector = connector;
    }

    protected MessageConsumer createConsumer() throws JMSException {
        this.consumerSession = this.consumerConnection.createTopicSession(false, 2);
        this.producerSession = this.producerConnection.createTopicSession(false, 1);
        TopicSubscriber consumer = null;
        consumer = this.consumerName != null && this.consumerName.length() > 0 ? (this.selector != null && this.selector.length() > 0 ? this.consumerSession.createDurableSubscriber(this.consumerTopic, this.consumerName, this.selector, false) : this.consumerSession.createDurableSubscriber(this.consumerTopic, this.consumerName)) : (this.selector != null && this.selector.length() > 0 ? this.consumerSession.createSubscriber(this.consumerTopic, this.selector, false) : this.consumerSession.createSubscriber(this.consumerTopic));
        return consumer;
    }

    protected Destination processReplyToDestination(Destination destination) {
        Topic topic = (Topic)destination;
        return this.jmsTopicConnector.createReplyToTopicBridge(topic, this.getConsumerConnection(), this.getProducerConnection());
    }

    protected MessageProducer createProducer() throws JMSException {
        this.producer = this.producerSession.createPublisher(null);
        return this.producer;
    }

    protected void sendMessage(Message message) throws JMSException {
        this.producer.publish(this.producerTopic, message);
    }

    public TopicConnection getConsumerConnection() {
        return this.consumerConnection;
    }

    public void setConsumerConnection(TopicConnection consumerConnection) {
        this.consumerConnection = consumerConnection;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public Topic getConsumerTopic() {
        return this.consumerTopic;
    }

    public void setConsumerTopic(Topic consumerTopic) {
        this.consumerTopic = consumerTopic;
    }

    public TopicConnection getProducerConnection() {
        return this.producerConnection;
    }

    public void setProducerConnection(TopicConnection producerConnection) {
        this.producerConnection = producerConnection;
    }

    public Topic getProducerTopic() {
        return this.producerTopic;
    }

    public void setProducerTopic(Topic producerTopic) {
        this.producerTopic = producerTopic;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }
}

